<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Http;

use Illuminate\Http\Request;
use App\Models\LeaveInformation;
use App\Models\LeavesAdmin;
use App\Models\Leave;
use DateTime;
use Session;
use DB;

class LeavesController extends Controller
{
    /** Leaves Admin Page */
    public function leavesAdmin()
    {
        // Fetch the list of users once
        $userList = DB::table('users')->get();
       
        
        // Get the count of users
        $usercount = $userList->count();  // Reuse the result of the above query
    
        // Get the leave information
        $leaveInformation = LeaveInformation::all();
    
        // Get all leave records
        $getLeave = Leave::all();
    
        // Pass the necessary data to the view
        return view('employees.leaves_manage.leavesadmin', compact('leaveInformation', 'userList', 'getLeave', 'usercount'));
    }
    

    /** Get Information Leave */
    public function getInformationLeave(Request $request)
    {
        try {

            $numberOfDay = $request->number_of_day;
            $leaveType   = $request->leave_type;
            $leaveDay = LeaveInformation::where('leave_type', $leaveType)->first();
            
            if ($leaveDay) {
                $days = $leaveDay->leave_days - ($numberOfDay ?? 0);
            } else {
                $days = 0; // Handle case if leave type doesn't exist
            }

            $data = [
                'response_code' => 200,
                'status'        => 'success',
                'message'       => 'Get success',
                'leave_type'    => $days,
                'number_of_day' => $numberOfDay,
            ];
            
            return response()->json($data);

        } catch (\Exception $e) {
            // Log the exception and return an appropriate response
            \Log::error($e->getMessage());
            return response()->json(['error' => 'An error occurred.'], 500);
        }
    }

    /** Apply Leave */
    public function saveRecordLeave(Request $request)
    {
        $leave = new Leave();
alert("leave Created ");
        
        return $leave->applyLeave($request);
    }

    /** Delete Record */
    public function deleteLeave(Request $request)
    {
        // Delete an instance of the Leave model
        $delete = new Leave();
        // Call the delete method
        return $delete->deleteRecord($request);
    }

    /** Leave Settings Page */
    public function leaveSettings()
    {
        return view('employees.leaves_manage.leavesettings');
    }

    /** Attendance Admin */
    public function attendanceIndex()
    {
        return view('employees.attendance');
    }

    /** Attendance Employee */
    public function AttendanceEmployee()
    {
        return view('employees.attendanceemployee');
    }
    public function getPunchData($empcode, $from_date, $to_date)
    {
        $corporate_id = 'IATTGUINDY';  // Your corporate ID
        $username = 'IATTGUINDY';      // Your API Username
        $password = 'IATT@2025';       // Your API Password
    
        // The URL with query parameters
        $url = "https://api.etimeoffice.com/api/DownloadInOutPunchData?Empcode={$empcode}&FromDate={$from_date}&ToDate={$to_date}";
    
        // Make the GET request with basic authentication and disable SSL verification
        $response = Http::withBasicAuth($username, $password)
                        ->withoutVerifying()  // Disable SSL certificate verification
                        ->get($url);
    
        // Check if the request was successful
        if ($response->successful()) {
            // Process the response data
            return response()->json([
                'status' => 'success',
                'data' => $response->json(),
            ]);
        } else {
            // Handle error response
            return response()->json([
                'status' => 'error',
                'message' => $response->body(),
            ]);
        }
    }
    
    public function updateStatus(Request $request)
    {
        // Validate the input data
        $request->validate([
            'id' => 'required|exists:leaves,id',
            'status' => 'required|string'
        ]);

        // Find the leave record and update the status
        $leave = Leave::find($request->id);
        $leave->status = $request->status;
        $leave->save();

        // Return a response indicating success
        return response()->json([
            'status' => 'success',
            'message' => 'Leave status updated successfully',
            'newStatus' => $request->status
        ]);
    }



    /** Leaves Employee Page */
    public function leavesEmployee()
    {
        $leaveInformation = LeaveInformation::all();
        $getLeave = Leave::where('staff_id', Session::get('user_id'))->get();

        return view('employees.leaves_manage.leavesemployee',compact('leaveInformation', 'getLeave'));
    }

    /** Shift Scheduling */
    public function shiftScheduLing()
    {
        return view('employees.shiftscheduling');
    }

    /** Shift List */
    public function shiftList()
    {
        return view('employees.shiftlist');
    }
}
