<?php

namespace App\Http\Controllers;

use App\Models\Project;
use App\Models\Client;
use App\Models\department;
use App\Models\Designation;
// use App\Models\Group;
use App\Models\User;
use Illuminate\Http\Request;

class ProjectController extends Controller
{
    // Show all projects
    public function index()
    {
        // $projects = Project::with(relations: ['client', 'group', 'assignedTo'])->get();
        $projects = Project::with(['client', 'assignedTo'])->get();
        $clients = Client::all();
        $users = User::all();
        $groups = department::all();
        // dd($projects);   
        return view('project.index', compact('projects', 'clients', 'groups', 'users'));
    }

    // Show the form for creating a new project
    public function create()
    {
        $clients = Client::all();
        $users = User::all();
        return view('projects.create', compact('clients', 'users'));
    }

    // Store a newly created project
    public function store(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'project_name' => 'required|string|max:255',
            // 'version' => 'required|string|max:50',
            // 'client_id' => 'required|exists:clients,id',
            // 'assigned_group_id' => 'required|exists:groups,id',
            // 'assigned_to_id' => 'required|exists:users,id',
            'status' => 'required|string',
            'start_date' => 'required|date',
            'end_date' => 'required|date',
            // 'billing_type' => 'required|string',
            'fixed_price' => 'nullable|numeric',
            'estimate_hours' => 'nullable|integer',
            'auto_progress' => 'nullable|boolean',
            'project_logo' => 'nullable|image|mimes:jpg,jpeg,png',
            'description' => 'nullable|string',
        ]);

        $data = $request->all();
    //    dd($data);

        if ($request->hasFile('project_logo')) {
            $imageName = time() . '.' . $request->project_logo->extension();
            $request->project_logo->move(public_path('images/projects'), $imageName);
            $data['project_logo'] = $imageName;
        }

        Project::create($data);

        return redirect()->route('projects.index')->with('success', 'Project created successfully!');
    }

    // Show the form for editing a project
    public function edit(Request $request)
    {
        $project = Project::find($request->input('id'));
        $clients = Client::all();
        $users = User::all();
        return response()->json(['project'=> $project,'clients'=> $clients,'users'=> $users]);
      
        // return view('projects.edit', compact('project', 'clients', 'users'));
    }

    // Update the project
    public function update(Request $request, Project $project)
    {
        $request->validate([
            'project_name' => 'required|string|max:255',
            // 'version' => 'required|string|max:50',
            'client_id' => 'required|exists:clients,id',
            // 'assigned_group_id' => 'required|exists:groups,id',
            'assigned_to_id' => 'required|exists:users,id',
            'status' => 'required|string',
            'start_date' => 'required|date',
            'end_date' => 'required|date',
            // 'billing_type' => 'required|string',
            'fixed_price' => 'nullable|numeric',
            'estimate_hours' => 'nullable|integer',
            'auto_progress' => 'nullable|boolean',
            'project_logo' => 'nullable|image|mimes:jpg,jpeg,png',
            'description' => 'nullable|string',
        ]);

        $data = $request->all();

        if ($request->hasFile('project_logo')) {
            $imageName = time() . '.' . $request->project_logo->extension();
            $request->project_logo->move(public_path('images/projects'), $imageName);
            $data['project_logo'] = $imageName;
        }

        $project->update($data);

        return redirect()->route('projects.index')->with('success', 'Project updated successfully!');
    }

    // Delete the project
    public function destroy(Project $project)
    {
        $project->delete();
        return redirect()->route('projects.index')->with('success', 'Project deleted successfully!');
    }
}
