<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    use HasFactory;

    protected $fillable = [
        'project_name', 'version', 'client_id', 'assigned_group_id', 'assigned_to_id', 'status', 'start_date', 'end_date', 'billing_type', 'fixed_price', 'estimate_hours', 'auto_progress', 'project_logo', 'description'
    ];

    // Relationships (Assuming you have Client, Group, and User models set up)
    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    // public function group()
    // {
    //     return $this->belongsTo(Group::class);
    // }

    public function assignedTo()
    {
        return $this->belongsTo(User::class, 'assigned_to_id');
    }
}
