<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->id();
            $table->string("project_name");
            $table->string("version")->nullable();
            $table->string("client_id")->nullable();
            $table->string("assigned_group_id");
            $table->string("assigned_to_id");
            $table->string("status");
            $table->timestamp("start_date");
            $table->timestamp("end_date");
            $table->string("billing_type")->nullable();
            $table->string("fixed_price")->nullable();
            $table->string("estimate_hours")->nullable();
            $table->string("auto_progress")->nullable();
            $table->string("project_logo")->nullable();
            $table->text("description");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};
