#  2.1.0 (2007-10-02)

SilverStripe 2.1.0 was released on '''2 October 2007''' and had the following changes:

## Overview

  * Comment administration section, and comment moderation
  * Allow CMS users to limit view/edit access to a page
  * Show an rss link for page comments on each page

## Upgrading

### Too many redirects

A problem occurs of 'too many redirects' or the page just doesn't load (home page) because of these situations:

   * Access tab for home page has 'logged in users only', OR
   * NO radio buttons have been set. This happens when upgrading site from old DB.

It's caused by a redirect to Security/login on the home page controller, which is blocked off, so you can't actually
login, so it infinitely loops a redirect. See http://open.silverstripe.com/ticket/1488

## Features and Enhancements

  * Theme support
  * Widget support
  * Better extension API
  * Unit testing framework
  * More API documentation
  * Added support for __ss_environment.php files
  * New classes
      * BankAccountField
      * BBCodeParser
      * HasManyComplexTableField
      * HasOneComplexTableField
      * ManyManyComplexTableField
      * NewsletterType
      * RestfulService (from mashups module)
   * Improved classes
      * ComplexTableField
          * Validation in popup
      * ContentController
          * Added project()
      * Controller
          * Added redirectedTo()
      * Convert
          * Added raw2htmlatt()
          * Added raw2mailto()
      * DatabaseAdmin
          * Drastically improved database build performance
      * DataObject
          * Added ID,ID,ID syntax for populating many-many joins
      * DataObjectDecorator
          * Allow member CMS fields to be added
      * DataObjectSet
          * Added getRange()
      * Date
          * Added past_date()
      * Director
          * Added set_dev_servers()
          * Added set_test_servers()
          * Added redirected_to()
          * Refactored CMS page-URL accessing to use ->AbsoluteLink(), which can be overridden by defining alternateAbsoluteLink()
      * Debug
          * Optionally hide backtrace-headers in message() and show() (applied in 'showqueries')
      * Email
          * MimeType-fallback (from /etc/mime.types)
          * Improved validation in is_valid_address()
      * FieldSet
          * Added insertAfter()
      * Form
        * Automatic filesystem backup of POST-data
      * FormField
          * Support for right-aligned titles
          * Custom CSS-classes by addExtraClass() and removeExtraClass()
      * Group
          * Added Description field
      * HtmlEditorField
          * Allow classes other than 'typography' to be set
      * Image
          * Added PaddedImage()
      * ImageField
          * Added readonly transformation
      * PageCommentInterface
          * Added anchors to page comments, and made rss feed link to them
      * Permission
          * Added $strict flag to check()
          * Allow passing of an array of permission codes to get_members_by_permission()
          * Added get_groups_by_permission()
      * PhoneNumberField
          * Improved validation
      * Security
         * Added basicauthlogin()
      * SecurityAdmin
          * Added EDIT_PERMISSIONS permission code
      * TableField
          * Validation and RequiredFields
      * TableListField
          * Added sorting, highlighting, formatting
          * Improved styling
      * TreeDropdownField
          * Improved styling
      * Varchar
          * Added RTF()
      * ViewableData
          * Added `<% if HasPerm(PERM_CODE() %>` for templates
  * Javascript
      * Implemented showIndicator() and hideIndicator()
      * Improved statusMessage() to clear manually instead of fixed interval
      * Added hideStatusMessage()

####  Bug Fixes

  * CMS
      * Fix specific newsletter bug
      * Don't show classes user doesn't have permissions to change to in class dropdown
      * Fix reading of Live pages in CMSMain
      * Fix double page reading after changing the class
      * Fix insert flash
      * Fix version regex for release candidates
      * Fix delete in Files and Images section
      * Fixed saving root folder causes error
      * Fixed "non-numeric ID" error that occurs when visiting newsletter section for a newsletter that doesn't exist (caused by session sometimes)
      * Fixed CMS sort subpages bug
  * Sapphire
      * Improved spam detection
      * Support for running SilverStripe in safe mode and under open_basedir restrictions
      * PHP notice fixes
      * Use normal authentification rather than basicauth for db/build
      * Fix CSS of profiler pop-up
      * Changed DropdownField $emptyString syntax from '0' to ''
      * Fixed IE6 DOM-parsing bug caused by FormResponse::load_form()
      * Triggering previewwrite for 'delete' and 'replace' SQL-actions
      * Changed record-insertion in DataObject
      * Boolean accepts database-default
      * Fixed Permission::get_members_by_permission()
      * Added memory_limit to publishall()
      * Fix many-many component set relation setting
      * The Link for a RedirectorPage points to its target
      * Add SQL_ prefix in place it was missing in Email
      * Added a check to make sure record exists before calling hasMethod on it in CheckboxSetField
      * Fixed bug in DataObject::addStaticVars()
      * Check for string 'true' as well as boolean in SiteTree::MetaTags()
      * Fix AllNewsletters value not being passed to OptionSetField in SubscribeForm
      * Improved the encapsulation of ErrorPage publication
      * Fix redirect back after failing login
      * Fixed renaming of .tar.gz and .tar.bz2 files
      * Fixed validation of DateField, EmailField and NumericField
      * Fix livesite bug for visibility handling difference between PHP5.2.0 and PHP5.1.6
      * Changed colouring of db/build to be more appropriate for the actual meaning of the messages
      * Fixed redirection from /home/ to /./ in IE6
      * Use the homepage as a model for the security base-page, so that things like the current subsite are factored in
      * Sorted permission codes in Permission::get_codes
      * Changes to support gallery module
      * Added missing has_many in DataObjectDecorator
      * Replace empty strings in SQL queries with NULL
  * JSParty
      * TinyMCE has been updated to 2.1.1.1

Installer

  * New installer look based on BlackCandy
  * Use the new theme system
  * Add first and last name fields
  * Added ability to set servers that will be in dev mode
  * When the posix module isn't present, throw a warning instead of dying
  * Warn if PHP version is less that 5.2.0 in support of GoPHP5 (http://www.gophp5.org)
  * Added favicon to installer and default template
  * Optional reporting of version information to SilverStripe
  * Installer now runs with short tags disabled
  * open_basedir and safe mode fixes
