# 2.3.10 (2010-12-21)

##  Overview

 * Security: XSS in controller handling for missing actions
 * Security: SQL injection with Translatable extension enabled
 * Security: Version number information disclosure
 * Security: Weak entropy in tokens for CSRF protection, autologin, "forgot password" emails and password salts
 * Security: HTTP referer leakage on Security/changepassword
 * Security: CSRF protection bypassed when handling form action requests through controller
 * Improved security of PHPSESSID and byPassStaticCache cookies (setting them to 'httpOnly')

##  Upgrading Notes 

See [2.4.4](2.4.4)

## Changelogs

### Features and Enhancements

 * [rev:114501] Added !RandomGenerator for more secure CSRF tokens etc. (from r114497) (from r114499)

### Bugfixes

 * [rev:115200] Removing form actions from  in !AssetAdmin, CMSMain, !LeftAndMain - handled through Form->httpSubmission() (merged from r115185)
 * [rev:115191] Checking for existence of !FormAction in Form->httpSubmission() to avoid bypassing $allowed_actions definitions in controllers containing this form
 * [rev:115191] Checking for $allowed_actions in Form class, through Form->httpSubmission() (from r115182)
 * [rev:114776] Disallow web access to sapphire/silverstripe_version to avoid information leakage (from r114773)
 * [rev:114772] Disallow web access to cms/silverstripe_version to avoid information leakage (from r114770)
 * [rev:114763] Avoid potential referer leaking in Security->changepassword() form by storing Member->!AutoLoginHash in session instead of 'h' GET parameter (from r114758)
 * [rev:114741] Fixed CSRF warning in image form after selecting a folder. (from r80237)
 * [rev:114517] Escaping $locale values in Translatable->augmentSQL() in addition to the i18n::validate_locale() input validation (from r114515) (from r114516)
 * [rev:114513] Limiting usage of mcrypt_create_iv() in !RandomGenerator->generateEntropy() to *nix platforms to avoid fatal errors (specically in IIS) (from r114510) (from r114512)
 * [rev:114509] Using !RandomGenerator class in Member->logIn(), Member->autoLogin() and Member->generateAutologinHash() for better randomization of tokens. Increased VARCHAR length of '!RememberLoginToken' and '!AutoLoginHash' fields to 1024 characters to support longer token strings. (from r114504) (from r114507)
 * [rev:114502] Using !RandomGenerator class in !SecurityToken->generate() for more random tokens (from r114500)
 * [rev:114266] Removing quotes from test data in !RestfulServiceTest, it gives different results depending on magic_quotes_gpc setting on PHP configuration (merged from r80132).