# 2.3.12 (2011-10-17)

## Overview

 * Security: Cross-site scripting on anchor links
 * Security: Possible SQL injection for MySQL when using far east character encodings
 * Security: SQL injection in Folder::findOrMake() parameter (used mostly in author-only CMS through `Upload::load()`)
 * Security: Privilege escalation from `EDIT_PERMISSIONS` to `ADMIN` for users access to the CMS (through `Member->getCMSFields()` and `TreeMultiselectField`)

## Upgrading Notes ##

See [2.4.6]

## Changelog

### Features and Enhancements

 * 2011-10-17 [8113e9c](https://github.com/silverstripe/sapphire/commit/8113e9c) Added SSViewer::getOption() as a logical counterpart to SSViewer::setOption() (Ingo Schommer)
 * 2011-02-07 [e2267a0](https://github.com/silverstripe/sapphire/commit/e2267a0) Added sapphire/docs (migrated from https://github.com/chillu/silverstripe-doc-restructuring) (Ingo Schommer)

### Bugfixes

 * 2011-10-18 [bdd6391](https://github.com/silverstripe/sapphire/commit/bdd6391) Respecting SSViewer::$options["rewriteHashlinks"] in SSViewer::process() (Ingo Schommer)
 * 2011-10-17 [52a895f](https://github.com/silverstripe/sapphire/commit/52a895f) Escaping base URLs for anchor links rewritten by SSViewer::process() with the 'rewriteHashlinks' option enabled (which is a framework default, and necessary because of the use of a &lt;base&gt; tag). Also added escaping for base URLs rendered through the 'php' variation of 'rewriteHashlinks' (Ingo Schommer)
 * 2011-09-15 [07dc3e9](https://github.com/silverstripe/silverstripe-cms/commit/07dc3e9) Consistently using Convert::raw2sql() instead of DB::getConn()-&gt;addslashes() or PHP's deprecated addslashes() for database escaping (Ingo Schommer)
 * 2011-09-15 [6d6c294](https://github.com/silverstripe/sapphire/commit/6d6c294) Consistently using Convert::raw2sql() instead of DB::getConn()-&gt;addslashes() or PHP's deprecated addslashes() for database escaping (Ingo Schommer)
 * 2011-03-09 [5bc0d00](https://github.com/silverstripe/sapphire/commit/5bc0d00) Avoid privilege escalation from EDIT_PERMISSIONS to ADMIN through TreeMultiselectField (in Member-&gt;getCMSFields()) by checking for admin groups in Member-&gt;onChangeGroups() (Ingo Schommer)

### Minor changes

 * 2011-02-21 [b37836f](https://github.com/silverstripe/sapphire/commit/b37836f) Added deprecated SapphireTest-&gt;assertType() in order to support PHPUnit 3.5 or newer, but stay backwards compatible to PHPUnit 3.4 (Ingo Schommer)
 * 2011-02-07 [e527e54](https://github.com/silverstripe/sapphire/commit/e527e54) Fixing image links in docs/en/tutorials/ (Ingo Schommer)

### Other

 * 2011-10-18 [fbe8b7b](https://github.com/silverstripe/sapphire/commit/fbe8b7b) MINO Switching 'rewriteHashlinks' sanitization from Convert::raw2att() to strip_tags() to make the resulting PHP more portable when mode is set to 'php' (Ingo Schommer)
 * 2011-09-15 [ca78784](https://github.com/silverstripe/sapphire/commit/ca78784) SECURITY Backporting MySQLDatabase-&gt;addslashes() to use mysql_real_escape_string() instead of the non-multibyte-safe addslashes() PHP function, and using it in Convert::raw2sql() (Ingo Schommer)