# 2.3.9 (2010-11-11)

##  Overview

 * Fixed a security issue where destructive controller actions are not correctly secured against Cross-Site Request Forgery (CSRF). This affects various CMS interfaces, as well as classes based on TableListField or ComplexTableField.
 * Compatibility with PHPUnit 3.5

See [2.4.3](2.4.3)

## 2.3.9 Changelog

### Features and Enhancements

 * [rev:113305] Added Form->enableSecurityToken() as a counterpart to the existing disableSecurityToken() (from r113284)
 * [rev:113293] Added !SecurityToken to wrap CSRF protection via "SecurityID" request parameter (from r113272)
 * [rev:111834] refactored runTests, using the new phpunit wrapper classes.
 * [rev:111832] Created a phpunit wrapper class to ensure that Sapphire's test framework is capable of running unit tests, coverage report and retrieve clover-statistics for PHPUnit 3.4 and PHPUnit 3.5


### API Changes

 * [rev:113321] Using Controller::join_links() to construct links in !ComplexTableField and !TableListField (partially merged from r88495, r96775)
 * [rev:113318] Fixed various controllers to enforce CSRF protection through Form_!SecurityToken on GET actions that are not routed through Form->httpSubmission(): !AssetAdmin, CMSBatchActionHandler, CMSMain, !CommentTableField, !LeftAndMain, !MemberTableField, !PageComment, !PageComment_Controller (from r113282)
 * [rev:113297] Added security token to !TableListField->Link() in order to include it in all URL actions automatically. This ensures that field actions bypassing Form->httpSubmission() still get CSRF protection (from r113275)


### Bugfixes

 * [rev:113319] Fixed Controller::join_links() handling of fragment identifiers (merged from r104580)
 * [rev:113302] Clear static marking caches on Hierarchy->flushCache() (from r113277)
 * [rev:113301] Fixed !ComplexTableField and !TableListField GET actions against CSRF attacks (with Form_!SecurityToken->checkRequest()) (from r113276)
 * [rev:113294] Using current controller for !MemberTableField constructor in Group->getCMSFields() instead of passing in a wrong instance (Group) (from r113273)
 * [rev:113158] Add PHPUnit includes to !SapphireTest class (can be loaded outside of !TestRunner for static calls, in which case the PHPUnit autoloaders/includes aren't in place yet) (merged from r113156)
 * [rev:111837] Using mock controller in !RestfulServiceTest to avoid problems with missing require() calls for PHPUnit/Framework.php (performed in recently merged PHPUnitWrapper::init() which is never called for "nested" true HTTP calls within unit tests). Mostly merged from branches/2.4.
 * [rev:111836] Renamed PHPUnit wrappers not to use underscores in classnames, as this confuses !ManifestBuilder prior to the 2.4 release


### Minor changes

 * [rev:113361] Fixed regression from r113282 for changed !SecurityToken API in CMSMain->publishall() (fixes #6159) (from r113360)
 * [rev:113312] Using !SecurityToken in !ViewableData->getSecurityID() (from r113274)
 * [rev:113308] Removed unused !SecurityAdmin->!MemberForm() and savemember() (see !MemberTableField) (from r113281)
 * [rev:113307] Removed unused !SecurityAdmin->removememberfromgroup() (see !MemberTableField) (from r113279)
 * [rev:113303] Reverted commented out code (regression from r113293)
 * [rev:113298] Fixed HTTPRequest class usage (regression from r113293)
 * [rev:111835] added phpdoc to the new PHPUnitWrapper classes.


### Other

 * [rev:111833] API-CHANGE: remove include which is not required.
 * [rev:111831] ENHACENEMENT: Change behaviour of the !MenufestBuilder to use spl_autoload_register instead of traditional __autoload.