# 3.1.11

# Overview

This release resolves a high level security issue in the SiteTree class, as well as 
the CMS controller classes which act on these objects during creation.

This release also resolves an issue affecting GridField on sites running in
an environment with Suhosin enabled.

## Upgrading

### SiteTree::canCreate Permissions

Any user code which overrides the `SiteTree::canCreate` method should be investigated to
ensure it continues to work correctly. In particular, a second parameter may now be passed
to this method in order to determine if page creation is allowed in any given context, whether
it be at the root level, or as a child of a parent page.

The creation of pages at the root level is now corrected to follow the rules specified 
by the SiteConfig, which in turn has been updated to ensure only valid CMS users are
granted this permission (when applicable).

The creation of pages beneath parent pages will now inherit from the ability to edit
this parent page.

User code which is not updated, but relies on the old implementation of SiteTree::canCreate will
now assume creation at the top level.

For example see the below code as an example

E.g.

	:::php
	<?php
	class SingletonPage extends Page {
		public function canCreate($member) {
			if(static::get()->count()) return false;
			
			$context = func_num_args() > 1 ? func_get_arg(1) : array();
			return parent::canCreate($member, $context);
		}
	}

For more information on the reason for this change please see the security announcement below.

## Security

 * 2015-03-11 [3df41e1](https://github.com/silverstripe/silverstripe-cms/commit/3df41e1) Fix SiteTree / SiteConfig permissions (Damian Mooyman) - See announcement [ss-2015-008](http://www.silverstripe.org/software/download/security-releases/ss-2015-008-sitetree-creation-permission-vulnerability)

### Bugfixes
 
 * 2015-03-09 [1770fab](https://github.com/silverstripe/sapphire/commit/1770fab) Fix gridfield generating invalid session keys (Damian Mooyman)
 * 2015-03-05 [87adc44](https://github.com/silverstripe/sapphire/commit/87adc44) Fix serialised stateid exceeding request length (Damian Mooyman)
 * 2015-03-04 [eb35f26](https://github.com/silverstripe/sapphire/commit/eb35f26) Corrected padding on non-sortable columns. (Sam Minnee)
 * 2015-03-03 [6e0afd5](https://github.com/silverstripe/sapphire/commit/6e0afd5) Prevent unnecessary call to config system which doesn't exist yet (micmania1)
 * 2015-03-03 [4709b90](https://github.com/silverstripe/sapphire/commit/4709b90) UploadField description alignment (Loz Calver)
 * 2015-03-02 [f234301](https://github.com/silverstripe/sapphire/commit/f234301) DataQuery::applyRelation using incorrect foreign key (fixes #3954) (Loz Calver)
 * 2015-03-02 [f9d493d](https://github.com/silverstripe/sapphire/commit/f9d493d) Fixes case insensitive search for postgres databases (Jean-Fabien Barrois)
 * 2015-02-27 [4c5a07e](https://github.com/silverstripe/sapphire/commit/4c5a07e) Updated docs (Michael Strong)
 * 2015-02-25 [3a7e24a](https://github.com/silverstripe/sapphire/commit/3a7e24a) Unable to access a list of all many_many_extraFields (Loz Calver)
 * 2015-02-13 [998c055](https://github.com/silverstripe/sapphire/commit/998c055) Misleading error message in SSViewer (Loz Calver)
 * 2015-02-10 [bbe2799](https://github.com/silverstripe/sapphire/commit/bbe2799) Use correct query when searching for items managed by a tree dropdown field #3173 (Jean-Fabien Barrois)
 * 2015-01-13 [ab24ed3](https://github.com/silverstripe/sapphire/commit/ab24ed3) Use i18n_plural_name() instead of plural_name() (Elvinas L.)
 * 2014-11-17 [a142ffd](https://github.com/silverstripe/silverstripe-cms/commit/a142ffd) VirtualPages use correct casting for 'virtual' database fields (Loz Calver)

## Changelog

 * [framework](https://github.com/silverstripe/silverstripe-framework/releases/tag/3.1.11)
 * [cms](https://github.com/silverstripe/silverstripe-cms/releases/tag/3.1.11)
 * [installer](https://github.com/silverstripe/silverstripe-installer/releases/tag/3.1.11)
