# 2.4.0-alpha1 (2009-11-11)

## Changelog

###  Overview

 * Support for hierarchical URLs
 * Support for MSSQL server database abstraction (via a separate module)
 * A "SiteConfig" record stores site-wide settings and default permissions and author groups for pages
 * "Permission Roles" are a simple way to combine multiple permission codes and assign them to groups in the Security interface. This makes permissions easier to maintain and less repetitive to set up.
 * The CMS searches for broken internal links to other pages and broken file references, and highlights them in the WYSIWYG editor
 * Dramatically reduced memory usage in CMS tree on larger sites (10,000+)
 * Performance improvements around Object and ViewableData property access.
 * Improved Shortcode API to allow for custom tag parsing in CMS content
 * More fine-grained permission control for translators
 * Improved unit test execution speed, increased number of tests cases by 30%
 * Better XSS security of the autologin token by using HTTPOnly cookies, more secure brute force login restrictions
 * Decreased memory usage in "Files & Images" section

###  New Features

 * [rev:91044] Added Session::destroy() as a means to remove the current session using session_destroy()
 * [rev:90036] Allow Text/Varchar fields to be configured to differentiate between NULL and empty string. (#4178, petebd)
 * [rev:89827] If there is no Name set, but there is an author, use the author's name (from r89650)
 * [rev:89221] batch actions for setting/resetting embargo/expiry (from r85397)
 * [rev:89194] SiteConfig (from r85339)
 * [rev:89193] Add a simple interface for administrating permission roles. (from r85297)
 * [rev:89190] SiteConfig (from r85339)
 * [rev:89189] Add a simple interface for administrating permission roles. (from r85297)
 * [rev:89176] Add another permission code that allows users to edit siteconfig without having admin priveleges (from r87261)
 * [rev:89157] Virtual pages now copy allowed children from the page they are
 * [rev:88992] Added MigrateSiteTreeLinkingTask to allow plain HTML links to be migrated into shortcode links. From: Andrew Short
 * [rev:88516] Added a SideReport to display all pages with broken page or file links. From: Andrew Short
 * [rev:88510] Re-instated broken link highlighting by manually checking all shortcodes in HtmlEditorField->Field(), and adding a class to broken ones. From: Andrew Short
 * [rev:88508] Added RequestHandler->allowedActions() to return a unified representation (including extensions) of all allowed actions on a controller.
 * [rev:88505] Added RequestHandler->hasAction() and Controller->hasAction() to check if a specific action is defined on a controller.
 * [rev:88503] Updated SiteTree::get_by_link() to integrate with translatable, and allow it to work across languages by implementing Translatable->alternateGetByLink().
 * [rev:88496] Refactored RootURLController to allow nested home pages.
 * [rev:88492] Updated HtmlEditorField to use DOMDocument to more reliably parse image tracking and shortcode link tracking data. From: Andrew Short
 * [rev:88484] Added SiteTree::get_by_link() to fetch the SiteTree object associated with a nested link.
 * [rev:88483] Allow you to access nested pages by falling over to a child page in ContentController if one is available. From: Andrew Short
 * [rev:88481] Allow you to link to SiteTree? objects in HTMLText or HTMLVarchar fields by using a "[sitetree_link id=n]" shortcode. From: Andrew Short
 * [rev:88474] Refactored ViewableData. The main changes are:
 * [rev:88472] Added the Shortcode API (ShortcodeParser) to allow you to replace simple BBCode-like tags in a string with the results of a callback. From: Andrew Short
 * [rev:88468] Added utility methods to enable and disable nested URLs to SiteTree. From: Andrew Short
 * [rev:88104] added extend() call to enable FieldHolder() html to be customized via extensions.
 * [rev:85789] Added Widget_Controller class to enable nested forms within Wiget class.


###  API Change

 * [rev:91048] Added Lower and Upper methods to Varchar, Text, and Enum
 * [rev:90963] Allow fieldList arguments to Form::loadDataFrom() and Form::saveInto(), for situations where the data passed only applies to a segment of the form. (from r90872)
 * [rev:90962] Inserting $HiddenFields into a form template will show the input tags of all the hidden fields. (from r90871)
 * [rev:90097] replaced Database::alteration_message() with DB::alteration_message()
 * [rev:90076] Renamed conflicting classes to have an "SS_" namespace, and renamed existing "SS" namespace to "SS_". The affected classes are: HTTPRequest, HTTPResponse, Query, Database, SSBacktrace, SSCli, SSDatetime, SSDatetimeTest, SSLog, SSLogTest, SSLogEmailWriter, SSLogErrorEmailFormatter, SSLogErrorFileFormatter, SSLogFileWriter and SSZendLog.
 * [rev:90075] Renamed conflicting classes to have an "SS_" namespace, and renamed existing "SS" namespace to "SS_". The affected classes are: HTTPRequest, HTTPResponse, Query, Database, SSBacktrace, SSCli, SSDatetime, SSDatetimeTest, SSLog, SSLogTest, SSLogEmailWriter, SSLogErrorEmailFormatter, SSLogErrorFileFormatter, SSLogFileWriter and SSZendLog.
 * [rev:90059] Added dev/tests/build, which runs everything, meaning that dev/tests/all doesn't need to run PhpSyntaxTes
 * [rev:89988] Add extra classes to WidgetHolder (#3855, patch from jshipman)
 * [rev:89841] Fixed change in r89716 to be more semantic with FileIFrameField
 * [rev:89726] TableListField customQuery and customCsvQuery won't automatically include ID, ClassName, and RecordClassName fields (from r87354)
 * [rev:89708] Change the way that Database::requireField() gets field type information from the underlying database driver. (from r82793)
 * [rev:89209] Added SapphireTest::logInWithPermission() (from r89012)
 * [rev:89205] Don't automatically set a default action on complex table fiels.  It leads to too many accidental clicks when trying to click a non-default action.  Still allow for people to explicitly select a default action. (from r88961)
 * [rev:89187] Added PermissionRole and PermissionRoleCode, along with relevant tests for the permission system. (from r85173)
 * [rev:88991] Updated Form->FormAction() to use Controller::join_links() rather than relying on the action parameter (to preserve b/c). From: Andrew Short
 * [rev:88797] HTTPRequest and HTTPResponse no longer inherit from Object, since they should not be extended. From: Andrew Short
 * [rev:88700] SSViewer and SQLQuery no longer inherit from Object, since they should not be extended. From: Andrew Short
 * [rev:88632] Added Debug::$friendly_error_header and Debug::$friendly_error_detail for customising the friendly error message. (from r69855)
 * [rev:88507] Decoupled ErrorPage::response_for() from the request and updated it so it will only return a response if an appropriate error page can be found.
 * [rev:88503] Moved lang_filter enabling & disabling into static methods on Translatable, and renamed to locale_filter.
 * [rev:88495] #3724: Unified the Link() method to accept an action parameter. From: Andrew Short
 * [rev:88296] support for advanced database options now included
 * [rev:88295] The advancedOptions variable now passed to the database connection
 * [rev:88294] $database_extensions static variable now supported
 * [rev:88293] The advancedOptions variable now passed to the database connection
 * [rev:88123] Requiring TRANSLATE_ALL or TRANSLATE_`<locale>` permission for authors without administrative access to edit translations
 * [rev:87894] array brackets removed for generation of field types
 * [rev:87893] Transaction stubs created
 * [rev:87568] array data type now supported
 * [rev:87567] array data type now supported
 * [rev:87566] array data type now supported
 * [rev:87565] array data type now supported
 * [rev:87564] array data type now supported
 * [rev:87563] array data type now supported
 * [rev:87562] array data type now supported
 * [rev:87561] array data type now supported
 * [rev:87560] array data type now supported
 * [rev:87559] array data type now supported
 * [rev:87558] array data type now supported
 * [rev:87557] array data type now supported
 * [rev:87555] array data types now supported by dev/build
 * [rev:87087] Added name argument to DB::getConn() and DB::setConn(), so that you can store multiple named connections.
 * [rev:86006] Removed Permission->listcodes(), use custom code
 * [rev:86002] Don't exempt 'index' controller actions from $allowed_actions check - they might still contain sensitive information (for example ImageEditor). This action has to explicitly allowed on controllers with $allowed_actions defined now.
 * [rev:85789] Removed unnecessary WidgetFormProxy class and Widget->FormObjectLink(), broken functionality since the RequestHandler restructuring in 2.3. Use Widget_Controller instead.
 * [rev:85073] Added DataObjectSet assertions to SapphireTest
 * [rev:85028] Added comparison argument to SSLog::add_writer()
 * [rev:84828] Added SSLogFileWriter to replace Debug::log_errors_to() and Debug::log_error_if_necessary() - the existing formatting for the Debug deprecation functions is now wrapped into SSLogErrorFileFormatter
 * [rev:84774] Debug::send_errors_to() and Debug::send_warnings_to() are deprecated in favour of SSLog. See class documentation for SSLog on configuration of error email notifications
 * [rev:84570] added onAfterSave in LeftAndMain
 * [rev:84523] Refactor CMSMenu internals to not generate the menu item list until its actually needed, rather than from a CMSMenu::populate_menu() call in cms/_config.php.  This lets an app/_config.php file actually manipulate the menu.
 * [rev:84521] If you can't create a given dataobject type, then don't show an import form in modeladmin
 * [rev:84161] Deprecated DataObject::databaseFields() in favour of the static DataObject::database_fields()
 * [rev:84160] Extension no longer inherits from Object.
 * [rev:84151] Make Object::uninherited_static() have a separate execution path to Object::get_static(), for more reliable operation.  The intention is that for any given static, you either use Object::get_static() or you use Object::uninherited_static() - not both.
 * [rev:84061] Database and Query no longer inherit from Object, since they shouldn't be extended with Extensions.


###  Bugfixes

 * [rev:91209] Return correct error when 404 page doesn't exist and page is not found.
 * [rev:91203] Fix concurrent editing message always being displayed on page version history.
 * [rev:91156] Returning TRUE on Translatable->hasTranslation() if called on a record that is in the current locale (merged from r91032)
 * [rev:91047] Don't failover to standard value in ViewableData_Customised if the customised value is defined but isn't set.  $obj->customise(array('Content'=>'')) should set Content to ''
 * [rev:91045] Session::destroy() should make use of setcookie() to remove the cookie from the user, unsetting the superglobal doesn't unset from the browser
 * [rev:91036] Added setup/teardown methods to SiteTreeBrokenLinksTest? to make it work with Translatable enabled (merged from r91033)
 * [rev:90964] use second argument only if its an array (from r90927)
 * [rev:90936] Fixed pages not being manipulated properly in the CMS because of a PHP error in CMSBatchAction
 * [rev:90934] MSSQL does not support double, using float instead (from r90928)
 * [rev:90876] Added ContentController->successfullyinstalled() to $allowed_actions
 * [rev:90857] applied patch from #4381. Observable doesnt play nice with jQuery (from r82094)
 * [rev:90855] Added rewriteHashlinks = 'php' option to SSViewer so that static publisher can handle internal hashlinks properly. (from r89612)
 * [rev:90854] Pass locale rather than language to spellchecker_languages (from r87869)
 * [rev:90853] Fixed Links to Moderate Comments from the CMS and front end. MINOR: removed complextable functions which no longer get called, moved logic to the PageComment Class (from r86325)
 * [rev:90852] Tied rollback action to edit, rather than publish, permission, since it only involves editing the draft site. (from r84957)
 * [rev:90851] Fix Form.FieldMap, used when constructing forms that have the HTML explicitly specified.
 * [rev:90850] Allow null default on MultiEnum fields
 * [rev:90849] Fixing the comment's author website url being converted to lowercase: now case is not affected. (from r84380)
 * [rev:90848] CMSMenuItem constructor now calls parent to respect inheritance (from r83586)
 * [rev:90845] Fixed bugs in content differencer, and improved styling. BUGFIX: fixed notice when getting title of member which didnt exist. Merged from trunk r77661. (from r81942)
 * [rev:90842] Added rewriteHashlinks = 'php' option to SSViewer so that static publisher can handle internal hashlinks properly. (from r89611)
 * [rev:90834] was being passed to foreach without a check to see if it's an array or not. (from r86202)
 * [rev:90833] Added required javascript files (behaviour, prototype, prototype_improvements) to the Field() method of TreeSelectorField.php (from r84320)
 * [rev:90831] WidgetArea now works. Can have multiple areas on a page, and has unit tests
 * [rev:90747] Fixed Text::scaffoldFormField() showing a "Is Null" checkbox, even if nullifyEmpty is true
 * [rev:90644] Fixed "Class not found CMSBatchAction_Unpublish ..." in BatchActionHandler.php, since this class was removed in r90489
 * [rev:90632] Make DataObject::dbObject('ClassName') work.
 * [rev:90595] When deleting a WidgetArea, delete all the widgets it contains.
 * [rev:90554] #4609: Fixed portoguese locales in common locales list.
 * [rev:90553] #4617: Make delete formatted images case-insensitive.
 * [rev:90552] #4642: Fixed creation of folders in non-english languages.
 * [rev:90551] Fixed glitch in permission code formats.
 * [rev:90550] Fixed glitch in permission code formats.
 * [rev:90548] #2476: Rename lowercase tables to correct casing if they have been transferred from a windows box.
 * [rev:90547] #4063: Corrected base tag for IE6
 * [rev:90196] fixed typo
 * [rev:90082] Don't skip flushCache() extension if $cache_get_one is empty on DataObject->flushCache()
 * [rev:90056] UTF-8 byte order mark gets propagated from template files (#4357)
 * [rev:90051] Remove blockquote from tinymce default plugin list - blockquote isnt a plugin in tinymce3.
 * [rev:90047] Some places want tableList() to have lower case, some want native case - return both!
 * [rev:90023] Security::$default_login_dest isn't used (#4179, simon_w)
 * [rev:90020] Reenable setting size on HasManyComplexTableField popups (#3921, rjmackay)
 * [rev:89911] Fixing regression in TranslatableTest due to outdated singleton caching.
 * [rev:89893] Moved SINGLETON resetting for test runs from SiteTreeTest/ObjectTest into SapphireTest - there should be no caching between all test invocations to avoid side effects
 * [rev:89881] Reset $_SINGLETONS cache in SiteTreeTest::tear_down() to avoid stale Translatable information. This broke SiteTreePermissionTest and SiteTreeTest when running in parallel with Translatable enabled.
 * [rev:89864] Added setup/teardown methods to CMSMainTest to fix test breakages when used alongside cmsworkflow module (which unsets the public batch action)
 * [rev:89863] Added setup/teardown methods to SiteTreeBacklinksTest to make it work with Translatable enabled
 * [rev:89825] Fix comment feed on SQLServer (from r89641)
 * [rev:89823] Made dragndropping possible for folders in ajax-expanded tree. Also fixed glitch in r82534 that made page drag and drop impossible (from r82571)
 * [rev:89821] repaired dragndropping files into nested directories - now code refers to the updated object which is initially hidden and zero sized (from r82534)
 * [rev:89812] If image does not exist in the file system, don't show a non-object error when viewing the Image/File record in AssetTableField (from r82390)
 * [rev:89811] Paging of search results now works for AssetTableField by overloading the TableListField link methods (from r81190, r82188)
 * [rev:89798] Removed double up of classes in TestRunner::coverage() (from r88463)
 * [rev:89731] Fixed ModelAdmin_CollectionController->Link() return value
 * [rev:89719] Folder::syncChildren() now uses far less memory - we do this by destroying the child object memory after use (from r82780)
 * [rev:89718] Fixed array to string conversion error in Date::setValue() (from r82749)
 * [rev:89716] disabling user ability to upload images into the CMS from their local computer (from r82573)
 * [rev:89715] Ensure that FileIFrameField gets the proper class, this could be a subclass of File instead
 * [rev:89714] Ensure that before creating default 404 error page, we don't have one already that exists with a record ID (from r81991)
 * [rev:89460] Hard code the migration task to use Content instead of the no-longer-used FieldName.  This should probably be improved to iterate over all HTMLText fields on the model.
 * [rev:89444] Removed SiteTree::rewriteLink() method that is no longer necessary due to the use of shortcodes.
 * [rev:89338] Respecting SiteTree->canDelete() in SiteTree->getCMSActions()
 * [rev:89333] Removed 'name' attribute from HeaderField markup - its invalid HTML to put in `<h*>` elements (#4623)
 * [rev:89328] Fixed CMSSiteTreeFilter
 * [rev:89236] Fixed SiteTree->validURLSegment() to perform a DataObject::get_one() instead of raw SQL, in order for decorated filtering (e.g. by the subsites module) to apply correctly.
 * [rev:89215] Detect a brokenh link on an incompletely specified redirector page. (from r89043)
 * [rev:89213] Fixed link generation in CTF default action (from r89026)
 * [rev:89208] Fixed image link rewriting and added a test. (from r89011)
 * [rev:89206] Fixed diabled image references for edit and delete links in CTF (from r88967)
 * [rev:89204] If a CTF without a show action is made readonly, don't add the show action back. (from r88960)
 * [rev:89203] Fixed resolution of amibiguous has_many foreign keys in ComplexTableField to use the same logic as DataObject (from r88945)
 * [rev:89200] Fixed inversion of condition created in r88869 (from r88905)
 * [rev:89199] AuthorID field for page version history wasn't being set. (from r88894)
 * [rev:89183] Fixed generation of static cache files in subdirectories. (from r88569)
 * [rev:89177] Fix image tracking not working cross subsite (from r88008)
 * [rev:89175] Fix broken link tracking of linked files (from r87252)
 * [rev:89172] Fix error when adding roles tab (from r86997)
 * [rev:89170] Fix image tracking to take resized images into account (from r86198)
 * [rev:89169] Fix items not deleting on tablefields (from r86099)
 * [rev:89163] Fixed RequestHandler->allowedActions() lowercasing of actions - was applying the logic, but not writing it back to the $actions array.
 * [rev:89161] Don't return empty value from ViewableData->XML_val() if the actual value is an uncasted 0 integeter (or anything else evaluating to untyped boolean false)
 * [rev:89003] Added PageComments to ContentController::$allowed_actions so commenting works. From: Andrew Short
 * [rev:88989] Reset broken file & link flags in HtmlEditorField->saveInto() before determining if a record contains broken links. From: Andrew Short
 * [rev:88957] Fixed missing default english text for "Clear" and "Search" buttons in template CMSMain_left.ss
 * [rev:88956] #4605 DataObject::newClassInstance() should repopulate it's defaults after changing to an instance of a different class, otherwise databases will complain of NULL values being written to columns that don't accept NULL values.
 * [rev:88799] Updated ModelAsController->findOldPage() query to be cross-database compatible. From: Andrew Short
 * [rev:88774] Stopped HtmlEditorField->saveInto() from dying when encountering a link that cannot be made relative. From: Andrew Short
 * [rev:88773] Suppressed errors in SS_HTMLValue->setContent() so it can handle malformed HTML.
 * [rev:88752] error messages suppressed as a temporary fix
 * [rev:88664] Fixed bugs in ViewableData casting system. From: Sam Minnee
 * [rev:88639] Set publication base_url on every URL, just in case it gets re-set by some rogue script (from r73510)
 * [rev:88523] Fix regression in r88521 that prevented the index action from being explictly disabled by setting the * key in allowed_actions
 * [rev:88522] Improved reliability of PhpSyntaxTest on build slave.
 * [rev:88521] Ensure that the index action works even if allowed_actions is set.
 * [rev:88513] #3858: Updated StaticExporter to handle nested pages. From: Andrew Short
 * [rev:88512] #3724: Updated Link() methods to accept an action parameter. From: Andrew Short
 * [rev:88508] Updated Controller->hasAction() to use RequestHandler->allowedActions() so that extension actions are recognised. From: Andrew Short
 * [rev:88503] Fixed viewing a translatable page by URL without explicitly setting a Locale in ContentController->handleRequest(). From: Andrew Short
 * [rev:88494] Fixed Controller::join_links() to properly handle multiple consecutive slashes. From: Andrew Short
 * [rev:88493] Use Link() on the controller to generate to form action path. From: Andrew Short
 * [rev:88473] #3862: Explicitly defined browsing and viewing actions on CodeViewer. From: Andrew Short
 * [rev:88471] #2133: Removed UniqueTextField JavaScript that was causing URLSegments to be incorrectly rewritten if they had a number at the end. From: Andrew Short
 * [rev:88469] Updated HTTP::findByTagAndAttribute() to be more versatile, especially when dealing with attributes containing special characters. From: Andrew Short
 * [rev:88218] #3685: Fixed setting of character set by default when no content negotiator is used.
 * [rev:88145] Added setup/teardown routines to SiteTreeActionsTest to avoid breaking with Translatable enabled on recent canTranslate()/canEdit() extensions
 * [rev:88143] Added setup/teardown routines to SiteTreeTest and SiteTreePermissionsTest to avoid breaking with Translatable enabled on recent canTranslate()/canEdit() extensions
 * [rev:88139] Changed CMSMain->LangSelector() to always return a DropdownField, which ensures the 'Locale' parameter is always available to be passed along with ajax queries
 * [rev:88138] Filter both 'available' and 'new' languages in LanguageDropdownField for canTranslate() permissions
 * [rev:88124] Added required permissions to TranslatableSearchFormTest
 * [rev:88003] Fixed CSVBulkLoaderTest not to assume ID ordering in the assertions, which breaks with databases not ordering by PK automatically (e.g. Postgres)
 * [rev:88000] Fixed SearchContextTest capitalization of string assertions
 * [rev:87926] Fixed SearchFilterApplyRelationTest not to assume ID ordering in the assertions, which breaks with databases not ordering by PK automatically (e.g. Postgres)
 * [rev:87925] Fixed SoapModelAccessTest not to assume ID ordering in the assertions, which breaks with databases not ordering by PK automatically (e.g. Postgres)
 * [rev:87922] Fixed RestfulServerTest not to assume ID ordering in the assertions, which breaks with databases not ordering by PK automatically (e.g. Postgres)
 * [rev:87913] Fixed ID associations in TableListFieldTest (was assuming numerically ascending IDs, which isnt necessarily true in Postgres)
 * [rev:87897] tests which aren't supported by Postgres temporarily disabled
 * [rev:87456] #4579: Translatable's call to new LanguageDropdownField() broked
 * [rev:87234] Fix MemoryLimitTest not to fail on machines with <1G of memory and later versions of PHP 5.2.x that check available memory before setting memory_limit setting.
 * [rev:87228] Fixed bug in recent changes to Hierarchy::liveChildren() to do with Translatable
 * [rev:87210] Fixed Hierarchy::liveChildren() to work on PostgreSQL
 * [rev:87131] Don't throw a notice-level error in DB::getConn() if connection hasn't been set yet, to mimic previous behaviour.
 * [rev:86876] Fixed content-type for SapphireSoapServer->wsdl() (#4570, thanks Cristian)
 * [rev:86556] missplaced quotes were ruining unit tests
 * [rev:86532] $params variable removed
 * [rev:86414] Fixed SearchFilterApplyRelationTest to match new SearchContext->addFilter() API: Needs the full name including relation instead of the ambiguous stripped name. This matches DataObject->scaffoldSearchFields() and getDefaultSearchContext()
 * [rev:86218] Initializing controllers through init() in WidgetArea->WidgetControllers()
 * [rev:86217] Return FALSE in SapphireTest->assertDOSEquals() if no valid DataObjectSet is passed in
 * [rev:86170] ID column in delete function now quoted properly
 * [rev:86085] Don't lowercase permission codes contained in $allowed_actions in RequestHandler->checkAccessAction(). Permission checks are case sensitive.
 * [rev:86060] Made SecurityAdminTest more resilient against changes to localized strings, by inspecting the CSV line-by-line instead
 * [rev:86008] Consistently returning from a Security::permissionFailure() to avoid ambiguous situations when controllers are in ajax mode
 * [rev:85817] Fixed WidgetControllerTest by adding missing url routing to ContentController (see r85789)
 * [rev:85758] Detecting DataObjectSet for readonly transformations in CheckboxSetField (thanks martijn, #4527)
 * [rev:85713] moved $versionAuthor variable invocation into a check for the existence of the $record variable on which it depends (Ticket #4458)
 * [rev:85696] Ticket #4220 - Copying of uploaded files from temp to assets folder fails on IIS installs; simple patch fixes it
 * [rev:85514] More robust URL handling in SecurityTest to avoid failing on custom /admin redirects
 * [rev:85513] More robust URL handling in CMSMainTest to avoid failing on custom /admin redirects
 * [rev:85336] Fixed SiteTree::can_edit_multiple() and canEdit() to collect permissions from different Versioned tables, which fixes querying a SiteTree record which has been deleted from stage for its permissions (e.g. in SiteTreeActionsTest)
 * [rev:85330] Disabled PHPUnit backup of global variables, which caused i18n::_t() calls in subsequent test cases to fail because of a cached empty  global
 * [rev:85310] Limiting i18n::include_by_locale() to scan directories only
 * [rev:85281] Implementing TestOnly interface in ModelAdminTest to avoid having it included automatically in CMSMenu and hence breaking other tests like LeftAndMainTest.
 * [rev:85157] #4423: Don't allow page duplication if canCreate is false.
 * [rev:85136] #3713 Escape HTTP request URL properly in DebugView::writeError() using htmlentities()
 * [rev:85130] merge r 85079 from branches/iss to fix Payment Validation of php side when submit a OrderForm
 * [rev:85120] Fix the bug in buildSQL() by trying to join an table with non-exsiting composite db field like "Money"
 * [rev:85086] #4463: Set AuthorID and PublisherID correctly
 * [rev:85085] Use default File classname in Folder::syncChildren()
 * [rev:85076] #3228 Fixed undefined offset error in Text::BigSummary() if trying to summarise text that is smaller than the requested word limit
 * [rev:85039] SelectionGroup.js typo, prevAl()l change to nextAll()
 * [rev:84980] Fixed issues with recent CMSMenu refactoring.
 * [rev:84976] SelectionGroup should include jQuery and jQuery livequery plugin when it's used or it will fail
 * [rev:84971] Fixed code for regenerating cached test manifest.
 * [rev:84843] #4486 Make use of DataObject::get_by_id() in File::getRelativePath() instead of building ID query manually in a get_one()
 * [rev:84796] Fixed querying of composite fields (broken due to inappropriate optimisation of hasField)
 * [rev:84789] Reverted some changes from r84163 because they broke cases where you have two fields of the same name on different subclasses.
 * [rev:84167] Performance improvement to Member::currentUserID()
 * [rev:84166] Performance imporvement to i18n::include_by_locale
 * [rev:84164] Removed deprecated (and slower) eregi_replace
 * [rev:84162] Removed some code that needed Extension to extend from Object.
 * [rev:84156] Ameneded r84151 so that the application order of extensions is the same as it was previously.
 * [rev:84155] Ameneded r84151 so that the application order of extensions is the same as it was previously.
 * [rev:84147] Added static resetting methods for more reliable test execution.
 * [rev:84093] Fixed SQLQuery::filtersOnID() for cases where a ClassName filter is inserted before the ID filter.
 * [rev:84092] Fixed filtering by archive date
 * [rev:84086] an time field input between 12:00pm to 12:59pm can't save back to database or always save as 00:00:00.
 * [rev:84079] VirtualPages won't call SiteTree_Controller anymore.
 * [rev:84068] Restored SiteTree::canView() functionality.
 * [rev:84066] Fixed some bugs in the performance fixes on Permission
 * [rev:84065] Fixed manifest builder tests to not have fake data, and to test that classes can be in files with different names
 * [rev:84064] Removed Requirements::combine_files() reference to non-existent cms/javascript/FilterSiteTree.js
 * [rev:84063] Don't make the Director completely fail if there was output prior to session_start() being called.
 * [rev:84000] prevent a nasty permissions situation where no one but an admin can edit a new page
 * [rev:83999] prevent a nasty permissions situation where no one but an admin can edit a new page
 * [rev:83970] Using standard SQL and SSDatetime::now() in SideReport_RecentlyEdited (see #4052)
 * [rev:83969] Fixed SiteTreeActionsTest to use unconditional class defintion - was failing due to recent changes in ClassInfo and class_exists()


###  Enhancement

 * [rev:91044] Added optional $sid parameter to Session::start() to start the session using an existing session ID
 * [rev:90084] Changed Hierarchy->numChildren() caching to be instance specific and respect flushCache(). This increases the amount of queries on large sets, but decreases the time for a single instance call (implemented in r89999)
 * [rev:89999] Only run a single query per class for Hierarchy::numChildren()
 * [rev:89883] Improved CMSSiteTreeFilter API to make it easier to create custom filter.s (from r89071, from r88465)
 * [rev:89820] Current search and current page of asset section are persistent. Fixes the open source ticket #4470 and also a part of #4256 (from r84091)
 * [rev:89815] FilesystemSyncTask: If folderID GET parameter is available, only synchronise that folder ID - useful for only synchronising a specific folder and it's children (from r82841)
 * [rev:89813] Return the results of the FilesystemSyncTask to the status message in the CMS instead of a generic success message (from r82618)
 * [rev:89724] Filesystem::sync() now accepts a folderID argument, meaning you can specifically target a folder and it's children to sychronise, instead of everything (from r82840)
 * [rev:89717] Filesystem::sync() will now return the number of added and deleted files and folders instead of null (from r82616, 82617 and 82724)
 * [rev:89182] Fixed sapphire execution if you run the uninstalled sake from a foreigh directory. (from r88533)
 * [rev:88635] Added Member::set_login_marker_cookie(), to let developers bypass static caching for logged-in users (from r73803)
 * [rev:88633] Make base tag in 404 page dynamic (from r72282)
 * [rev:88570] Improved performance of ViewableData casting by removing an object::get_static call From: Sam Minnee
 * [rev:88518] #3729: Updated the link inserter to insert a shortcode rather than a plain HTML link. From: Andrew Short
 * [rev:88505] Updated ContentController->handleRequest() to use Controller->hasAction() to check whether to fall over to a child page, rather than relying on an error response from Controller->handleRequest(). From: Andrew Short
 * [rev:88504] Cached the value for RootURLController::get_homepage_link() between calls. From: ajshort
 * [rev:88502] Updated the SiteTree URLSegment conflict resolver to work with nested URLs.
 * [rev:88501] Updated SiteTree CMS fields to be in line with nested URL changes. From: Andrew Short
 * [rev:88499] Refactored ModelAsController to only grab the first page of a request, then pass control on to it. From: Andrew Short
 * [rev:88491] #3279: Updated the link inserter to insert a shortcode rather than a plain HTML link. From: Andrew Short
 * [rev:88489] Updated the SiteTree link and section code to derive data from the current page, rather than relying on its own cache.
 * [rev:88488] Added Hierarchy->getAncestors() to return all the parent objects of the class in a DataObjectSet. From: Andrew Short
 * [rev:88487] Update ContentController to manually set the current Director page in handleRequest().
 * [rev:88482] Refactored TreeDropdownField to generate and manage the tree using Hierarchy's ParentID data, rather than relying on the client. From: Andrew Short
 * [rev:88480] Added ErrorPage::response_for() to get a response for a HTTP error code and request.
 * [rev:88479] Added ModelAsController::controller_for() to link a SiteTree object to its controller. From: Andrew Short
 * [rev:88478] Added HTTPRequest->isMedia() to check if a request is for a common media type. From: Andrew Short
 * [rev:88477] Added Controller->hasActionTemplate() to check if a template exists for a specific action. From: Andrew Short
 * [rev:88476] Updated SiteTree linking methods to generate nested URLs.
 * [rev:88474] Added template and value methods to database fields.
 * [rev:88139] Passing sitetree instance to CMSMain->LangSelector() in order to trigger canTranslate() filtering
 * [rev:88125] Added Translatable->getAllowedLocalesForMember()
 * [rev:88123] Added Translatable->providePermissions()
 * [rev:87777] Added ComponentSet->getComponentInfo() (#4587, thanks rorschach)
 * [rev:86506] Database specific version of RANDOM() created
 * [rev:86402] Added SearchContext->getFullName() to preserve the original fieldname including the relationship
 * [rev:86338] Added TableListField->paginationBaseLink
 * [rev:86216] Supporting full parameter signature in Versioned->Versions(), allVersions()
 * [rev:86027] Limiting "alc_enc" cookie (remember login token) to httpOnly to reduce risk of information exposure through XSS
 * [rev:86026] Added full parameter signature of PHP's set_cookie() to Cookie::set(), including the new $httpOnly flag
 * [rev:86021] Avoid information disclosure in Security/lostpassword form by returning the same message regardless wether a matching email address was found in the database.
 * [rev:86017] Added Member->FailedLoginCount property to allow Member->registerFailedLogin() to persist across sessions by writing them to the database, and be less vulnerable to brute force attacks. This means failed logins will persist longer than before, but are still reset after a valid login.
 * [rev:85823] Allowing Widget->Content() to render with any templates found in ancestry instead of requiring a template for the specific subclass
 * [rev:85789] Added handleWidgets() to ContentController to support new Widget_Controller class
 * [rev:85736] added tinymce valid element to allow style, ids and classes on any element to allow for styling hooks. Ticket: #4455
 * [rev:85731] hide unmoderated page comments from the page comment RSS feed. Ticket #4477
 * [rev:85716] Ticket #3910 - MySQL Time Zone support (alternative time zone to that of the website to which the server is set to)
 * [rev:85709] added option to truncate (clear) database table before importing a new CSV file with CSVBulkerLoader and ModelAdmin.
 * [rev:85700] Ticket #4297 - Use Director::baseFolder instead of relative links in sapphire/core/Image.php
 * [rev:85281] Filtering out TestOnly classes in CMSMenu::get_cms_classes()
 * [rev:84860] convert SelectionGroup.js from prototype version to jQuery version
 * [rev:84816] Updated SSLogErrorEmailFormatter to support NOTICE priority level logging
 * [rev:84774] Added SSLog, SSLogEmailWriter and SSLogErrorEmailFormatter for silverstripe message reporting
 * [rev:84165] Improved performance of DataObject::hasField()
 * [rev:84160] Object::__construct() performance improved slightly.
 * [rev:84159] Improved performance of Object::uninherited_static()
 * [rev:84158] Improved performance of Object::allMethodNames() and Object::addMethodsFrom()
 * [rev:84149] add more assertion in SearchFilterAapplyRelationTest to test more cases for many_many relation.
 * [rev:84117] add more assertion in SearchFilterAapplyRelationTest to test more cases for many_many relation.
 * [rev:84113] add "InnerJoin" clause for an has_many component's ancestry classes for SearchFilter::applyRelation() so that an searchfliter could filter on that component's ancestry's field. add unit tests for this enhancement and r83500
 * [rev:84073] added new permission, SITETREE_REORGANISE
 * [rev:83798] #3638: There is no longer any need to have the class name match the PHP filename
 * [rev:83789] Added ClassInfo::is_subclass_of() for better performance
 * [rev:83674] sitetree filters now show up in a dropdown, and you can add your own by extending CMSSiteTreeFilter


###  Other

 * [rev:90071] Merge branch 'master' of :sminnee/sapphire From: Sam Minnee 
 * [rev:89715] (from r82175)
 * [rev:89702] Merge branch 'master' of :sminnee/silverstripe-cms From: Sam Minnee 
 * [rev:89224] slightly later, so FormResponses can be overridden if necessary. (from r85614)
 * [rev:89220] ENHANCMENT side reports can now have parameters (from r85329)
 * [rev:89207] ENHANCMENT improved reporting around broken links/files (from r88993)
 * [rev:89186] #108 - Subsite Virtual Page ordering (from r84848)
 * [rev:89178] as they are confusing. (from r88019)
 * [rev:89174] #148 - Stable against restructures (from r87251)
 * [rev:89157] pointing at. (from r85197)
 * [rev:89155] #63 - Stable against restructures (from r84861)
 * [rev:88638] Add support for configuring multiple static publisher on a single site (from r70203)
 * [rev:88637] Basic authentication now (back) in configurefromenv.php (from r82551)
 * [rev:88527] Added readme for github From: Sam Minnee 
 * [rev:88525] Added readme for GitHub copy of SilverStripe. From: Sam Minnee 
 * [rev:88474]      * Removed ViewableData_ObjectCustomised - now just uses ViewableData_Customised.
 * [rev:87896] Transaction test created
 * [rev:86684] Merged in Requirements::combine_files() fix from branches/2.3 - r83048
 * [rev:86679] Merged in Member::sendInfo() bug fixes from branches/2.3 - r85779
 * [rev:86678] Merged in Email template codes change from branches/2.3 - r84594
 * [rev:86676] Merged in parent::__construct() additions from branches/2.3 - r83580 and r83587
 * [rev:86669] Merged Text::ContextSummary() changes from branches/2.3 - r82035 and r82036
 * [rev:86655] Patched to allow id|class|style|title attributes in all elements and allow empty td cells (will pad with non-breaking space) in line with #4332 and 4497 in 2.3.x changes to cms/LeftAndMain.php
 * [rev:84981] Ensure that DataObject->ClassName is set on object instantiation
 * [rev:84970] Made timing code for test runner more accurate (includes initial db build):
 * [rev:84814] ENHANCMENT: get svn merged revision 84806:84808 from branches/iss
 * [rev:84163] ENHANCMENT: Low-level performance improvements in database access.