# 3.0.2-rc1 #

## Overview ##

3.0.2 RC1 provides a number of bugfixes and minor enhancements, continuing to build on the 3.0.1 release, with a particularly focus on CMS UI consistency.

Upgrading from 3.0.x should be a straightforward matter of dropping in the new release, however, please note the API changes in case you relied on the old behaviour.  The changes to the APIs wont' affect most users.

### API Changes

 * 2012-08-27 [c2a8eec](https://github.com/silverstripe/sapphire/commit/c2a8eec) Changed behaviour of HTTP_Request::params to include route table params (as per 2.4 behaviour, see FIX: below). ADDED: HTTP_Request::params() to retrieve all (shifted) params used in the request FIXED: Issue where route-table level arguments would not be accessible without using non-deprecated API. ADDED: Test case to test the above items UPDATED: Extended Director::test to allow for the retrieval of the request object UPDATED: Deprecated notice on Director::urlParam and Director::urlParams REMOVED: Unused variable FIXED: Coding convention conformity (Damian Mooyman)
 * 2012-08-23 [fa37c44](https://github.com/silverstripe/sapphire/commit/fa37c44) Reverse config extra statics control flow (Hamish Friedlander)
 * 2012-08-19 [70b22fa](https://github.com/silverstripe/sapphire/commit/70b22fa) GridFieldConfig should extend object to make use of Object::create() this also fixes GridFieldConfig_RecordViewer::create() which was not working before (Zauberfisch)
 * 2012-07-23 [c2414aa](https://github.com/silverstripe/sapphire/commit/c2414aa) Debug::showError() no longer calls exit() (fixes #2644) (jakr)
 * 2012-07-16 [70eaa27](https://github.com/silverstripe/sapphire/commit/70eaa27) Allow to force URL reload, while replacing the history state (Mateusz Uzdowski)

### Features and Enhancements

 * 2012-08-30 [19772f3](https://github.com/silverstripe/sapphire/commit/19772f3) Updates to the GridField documentation (fixes #7524) (Stig Lindqvist)
 * 2012-08-29 [cc2e250](https://github.com/silverstripe/sapphire/commit/cc2e250) Allow querying if a field exists on a table (Hamish Friedlander)
 * 2012-08-29 [949507c](https://github.com/silverstripe/silverstripe-cms/commit/949507c) Add warning if viewed SiteTree object class is obsolete (Hamish Friedlander)
 * 2012-08-27 [2e21574](https://github.com/silverstripe/sapphire/commit/2e21574) FieldGroup_DefaultFieldHolder template (Ingo Schommer)
 * 2012-08-27 [1d2288b](https://github.com/silverstripe/sapphire/commit/1d2288b) Open external links in preview mode in new window (fixes #7652) (Ingo Schommer)
 * 2012-08-27 [cd8c3a0](https://github.com/silverstripe/silverstripe-cms/commit/cd8c3a0) Re-added SilverStripeNavigator styling (Ingo Schommer)
 * 2012-08-27 [6009cfa](https://github.com/silverstripe/sapphire/commit/6009cfa) Allow debugging of config cyclic errors (Hamish Friedlander)
 * 2012-08-21 [66dfa38](https://github.com/silverstripe/sapphire/commit/66dfa38) GreaterThanFilter should be consistent with LessThanFilter (unclecheese)
 * 2012-08-19 [82500dd](https://github.com/silverstripe/sapphire/commit/82500dd) Custom menu icons for the CMS main menu (martimiz)
 * 2012-08-17 [4fde42f](https://github.com/silverstripe/sapphire/commit/4fde42f) Add "jpeg" to list of allowed extensions (unclecheese)
 * 2012-08-07 [1432a8e](https://github.com/silverstripe/sapphire/commit/1432a8e) create TestRunner setdb URL endpoint (Michał Ochman)
 * 2012-07-26 [c97ed78](https://github.com/silverstripe/silverstripe-cms/commit/c97ed78) Maori Language javascript (Naomi Guyer)
 * 2012-07-26 [55ec92d](https://github.com/silverstripe/sapphire/commit/55ec92d) Maori language javascript (Naomi Guyer)
 * 2012-07-20 [0c0bcc9](https://github.com/silverstripe/sapphire/commit/0c0bcc9) Rewritten tutorial 5 to GridField API (Ingo Schommer)
 * 2012-07-20 [11c71e1](https://github.com/silverstripe/sapphire/commit/11c71e1) Updated tutorial 4 (Naomi Guyer)
 * 2012-07-06 [766b03f](https://github.com/silverstripe/sapphire/commit/766b03f) add selectsession URL endpoint (Michał Ochman)
 * 2012-06-25 [5f94d23](https://github.com/silverstripe/sapphire/commit/5f94d23) Ntfcatn. image embedding(trac #7438) (mightycoco)
 * 2012-06-11 [21bcc01](https://github.com/silverstripe/silverstripe-cms/commit/21bcc01) Made the tree search form more extensible. (Andrew Short)

### Bugfixes

 * 2012-09-02 [fd8e852](https://github.com/silverstripe/silverstripe-cms/commit/fd8e852) Disallow "add page here" shortcut to avoid $allowed_children edge cases (fixes #7694) (Ingo Schommer)
 * 2012-09-02 [1cd82e2](https://github.com/silverstripe/silverstripe-cms/commit/1cd82e2) Enforce $allowed_children in controllers on page creation (fixes #7694) (Ingo Schommer)
 * 2012-09-02 [52263e6](https://github.com/silverstripe/sapphire/commit/52263e6) Gridfield fails when save changes filter criteria (fixes #7785) (Ingo Schommer)
 * 2012-09-02 [fb6efb9](https://github.com/silverstripe/sapphire/commit/fb6efb9) Calling extraStatics() with args (regression from fa37c448) (Ingo Schommer)
 * 2012-09-01 [d24ea5e](https://github.com/silverstripe/sapphire/commit/d24ea5e) jQueryUI configs broken because keys were all lowercase (Zauberfisch)
 * 2012-08-30 [e540166](https://github.com/silverstripe/silverstripe-cms/commit/e540166) Filter pages by LastEdited always returns an empty list (Saophalkun Ponlu)
 * 2012-08-30 [f3fcae3](https://github.com/silverstripe/sapphire/commit/f3fcae3) Fix wrong date conversion from PHP format 'y' to jquery date and back. (Saophalkun Ponlu)
 * 2012-08-29 [651cb03](https://github.com/silverstripe/silverstripe-cms/commit/651cb03) Removed 'Sort' field from CMSMain edit form (Ingo Schommer)
 * 2012-08-29 [f070f97](https://github.com/silverstripe/sapphire/commit/f070f97) Allow custom getters in summaryFields() (fixes #7788) (Ingo Schommer)
 * 2012-08-29 [c3d622c](https://github.com/silverstripe/sapphire/commit/c3d622c) Fix an issue caused by moving a page from one location in the tree to another location doesn't update parent id in the edit form immediately (see #7740) The issue causes the moved page to revert to previous location when Save and Publish before any page refresh or page switching. This commit also adds 'Modified' badge to the moved page (Saophalkun Ponlu)
 * 2012-08-28 [cec461b](https://github.com/silverstripe/silverstripe-cms/commit/cec461b) Use AbsoluteLiveLink() for CMS previews (Ingo Schommer)
 * 2012-08-28 [8a514d8](https://github.com/silverstripe/silverstripe-cms/commit/8a514d8) Correct live state in SiteTree-&gt;getAbsoluteLiveLink() (Ingo Schommer)
 * 2012-08-28 [f454f48](https://github.com/silverstripe/silverstripe-cms/commit/f454f48) Session namespace sharing for CMS controllers (Ingo Schommer)
 * 2012-08-27 [dc08e87](https://github.com/silverstripe/sapphire/commit/dc08e87) Take first non-empty link field for preview (Ingo Schommer)
 * 2012-08-27 [62783c7](https://github.com/silverstripe/silverstripe-cms/commit/62783c7) Prevent overwriting of draft/live preview form fields (Ingo Schommer)
 * 2012-08-27 [f638935](https://github.com/silverstripe/sapphire/commit/f638935) Fix CMS layout after preview navigation (fixes #7463) (Ingo Schommer)
 * 2012-08-27 [e59aec3](https://github.com/silverstripe/silverstripe-cms/commit/e59aec3) Redirect to edit view after page revert in CMS (fixes #7391) (Ingo Schommer)
 * 2012-08-27 [3e351bc](https://github.com/silverstripe/sapphire/commit/3e351bc) open ticket 7812 correcting filter syntax on a DataObject used by function updatetreenodes (Kirk Mayo)
 * 2012-08-23 [87685ee](https://github.com/silverstripe/sapphire/commit/87685ee) Fix Versioned's stage_unique mode on PostgreSQL. (Sam Minnee)
 * 2012-08-23 [ed0341e](https://github.com/silverstripe/sapphire/commit/ed0341e) Ensure that subtracting a sorted DataList works. (Sam Minnee)
 * 2012-08-22 [ae9c2e7](https://github.com/silverstripe/sapphire/commit/ae9c2e7) Restore tree children after updateNode() (fixes #7761) (Ingo Schommer)
 * 2012-08-22 [4fdc76d](https://github.com/silverstripe/silverstripe-cms/commit/4fdc76d) Installer templates (Naomi Guyer)
 * 2012-08-22 [69182c2](https://github.com/silverstripe/sapphire/commit/69182c2) Installer implies empty template used in tutorial (Naomi Guyer)
 * 2012-08-21 [9a8313d](https://github.com/silverstripe/sapphire/commit/9a8313d) GridField delete icon now correctly deletes, rather than always just unlinking (Fixes 7801) (James Cocker)
 * 2012-08-21 [296ee1f](https://github.com/silverstripe/sapphire/commit/296ee1f) Add double quotes to index columns for more reliable DB-schema management. (Sam Minnee)
 * 2012-08-21 [dd302a6](https://github.com/silverstripe/sapphire/commit/dd302a6) Ensure that all_versions are sorted explicitly for better cross-db behaviour. (Sam Minnee)
 * 2012-08-20 [06cddb7](https://github.com/silverstripe/sapphire/commit/06cddb7) Force refresh of GridFieldDetailEditForm after save (Ingo Schommer)
 * 2012-08-17 [5f9362e](https://github.com/silverstripe/silverstripe-cms/commit/5f9362e) Visual cue that URLSegment is updating (Ryan Wachtl)
 * 2012-08-16 [2923e55](https://github.com/silverstripe/silverstripe-cms/commit/2923e55) Restrict URLSegment preview to editable fields (Ingo Schommer)
 * 2012-08-15 [f79d2df](https://github.com/silverstripe/sapphire/commit/f79d2df) More robust url comparison in CMS (Ingo Schommer)
 * 2012-08-15 [3ca24a8](https://github.com/silverstripe/sapphire/commit/3ca24a8) Installer failed complaining about rewrite server-capability: XHR response was 3 chars long and therefore !== "OK" MINOR: Added charset &lt;meta&gt; declaration to prevent errors cluttering up browser-based debugger console output (Russell Michell)
 * 2012-08-12 [395580b](https://github.com/silverstripe/sapphire/commit/395580b) Locale-isolated i18n/Zend cache (Ingo Schommer)
 * 2012-08-12 [4bbd904](https://github.com/silverstripe/silverstripe-cms/commit/4bbd904) fix getting translated string for page type description (Fixes #7781). (Will Rossiter)
 * 2012-08-10 [ce2d31b](https://github.com/silverstripe/sapphire/commit/ce2d31b) Consistently self-closing form field tags (#7557) (Ingo Schommer)
 * 2012-08-10 [b649c09](https://github.com/silverstripe/sapphire/commit/b649c09) prevent notice when using selection group (Jak)
 * 2012-08-10 [5c5a506](https://github.com/silverstripe/sapphire/commit/5c5a506) removed use of deprecated method (Nik Rolls)
 * 2012-08-10 [ca1d38d](https://github.com/silverstripe/sapphire/commit/ca1d38d) Localize DataObject-&gt;summaryFields() (Ingo Schommer)
 * 2012-08-09 [deb3780](https://github.com/silverstripe/sapphire/commit/deb3780) #7768 - add-button and breadcrumb translation in Security, ModelAdmin (martimiz)
 * 2012-08-09 [ec17d36](https://github.com/silverstripe/sapphire/commit/ec17d36) Fix PHPUnit autoloading problems in text collector (Ingo Schommer)
 * 2012-08-08 [03e4893](https://github.com/silverstripe/silverstripe-cms/commit/03e4893) Fixing a issue with a undefined variable in getLink (Kirk Mayo)
 * 2012-08-06 [39a9093](https://github.com/silverstripe/silverstripe-cms/commit/39a9093) SiteTree-&gt;provideI18nEntities() limited to class (Ingo Schommer)
 * 2012-08-06 [e925401](https://github.com/silverstripe/silverstripe-cms/commit/e925401) Re-added singular/plural name i18n entities (Ingo Schommer)
 * 2012-08-06 [52e05f2](https://github.com/silverstripe/sapphire/commit/52e05f2) Re-added singular/plural name i18n entities (Ingo Schommer)
 * 2012-08-06 [1db8307](https://github.com/silverstripe/sapphire/commit/1db8307) Class autoloading in i18nTextCollector (Ingo Schommer)
 * 2012-08-06 [77ec21f](https://github.com/silverstripe/silverstripe-cms/commit/77ec21f) Fully qualified namespace for _t() in templates (Ingo Schommer)
 * 2012-08-06 [d0a9811](https://github.com/silverstripe/sapphire/commit/d0a9811) Fully qualified namespace for _t() in templates (Ingo Schommer)
 * 2012-08-06 [b135218](https://github.com/silverstripe/sapphire/commit/b135218) Detect JS lang by &lt;body&gt;, and force init (Ingo Schommer)
 * 2012-08-03 [a855309](https://github.com/silverstripe/sapphire/commit/a855309) javascript tree node updating fails when Translatable is used (Niklas Forsdahl)
 * 2012-08-02 [76c5b56](https://github.com/silverstripe/sapphire/commit/76c5b56) augmentSQL always extended on base data class on query finalization (Niklas Forsdahl)
 * 2012-08-01 [fb9e997](https://github.com/silverstripe/sapphire/commit/fb9e997) Use tree/xxx instead of tree?ID=xxx when fetching subtrees for TreeDropdownField. Fix #7730 (jean)
 * 2012-07-31 [7c0e387](https://github.com/silverstripe/silverstripe-cms/commit/7c0e387) Missing preview archive version button (fixes 7656) (Naomi Guyer)
 * 2012-07-26 [18a40b4](https://github.com/silverstripe/silverstripe-cms/commit/18a40b4) Adding siteconfig translations (Ruud Arentsen)
 * 2012-07-26 [7dfc7de](https://github.com/silverstripe/silverstripe-cms/commit/7dfc7de) Missing comma in Maori language translation (Naomi Guyer)
 * 2012-07-26 [a605d06](https://github.com/silverstripe/sapphire/commit/a605d06) Logo padding in collapsed Menu (Naomi Guyer)
 * 2012-07-24 [143eceb](https://github.com/silverstripe/sapphire/commit/143eceb) Correct wrong parameter order. (Mateusz Uzdowski)
 * 2012-07-20 [ee2b1a9](https://github.com/silverstripe/silverstripe-cms/commit/ee2b1a9) Check for the parameter existence. (Mateusz Uzdowski)
 * 2012-07-09 [63ad68a](https://github.com/silverstripe/silverstripe-cms/commit/63ad68a) fixing an edge-case bug where a 404-page would get statically published and overwrite the homepage of the site (this would sometimes happen when a RedirectorPage was set to an external URL and still referenced an internal page ID) (Julian Seidenberg)
 * 2012-06-04 [97d678b](https://github.com/silverstripe/silverstripe-cms/commit/97d678b) Provide default constructor value to filesystem publisher so that singleton calls (which don't pass params) don't fail (Marcus Nyeholt)
 * 2012-03-14 [2facc31](https://github.com/silverstripe/sapphire/commit/2facc31) Case insensitive search filters for PostgreSQL (fixes #6548) (Ingo Schommer)

### Other

 * 2012-09-03 [540f238](https://github.com/silverstripe/sapphire/commit/540f238) Added IRC notifications to Travis (Sam Minnee)
 * 2012-09-02 [b99c9e8](https://github.com/silverstripe/sapphire/commit/b99c9e8) Add reference to documentation directory structure (Will Rossiter)
 * 2012-09-01 [e624742](https://github.com/silverstripe/sapphire/commit/e624742) Make the border colors of test report status texts more subtle thus less distracting (Saophalkun Ponlu)
 * 2012-09-01 [60987ac](https://github.com/silverstripe/sapphire/commit/60987ac) Various minor visual enhancements for Sapphire test report (Saophalkun Ponlu)
 * 2012-08-31 [85ab39b](https://github.com/silverstripe/sapphire/commit/85ab39b) FIX 7832 Lang files for ss macron plugin - correct path to "langs", not "lang" MINOR Use consistent ed.getLang method (jean)
 * 2012-08-30 [10d0296](https://github.com/silverstripe/sapphire/commit/10d0296) FIX: ensure date input has a date picker to trigger open (#7504) (Will Rossiter)
 * 2012-08-30 [678232f](https://github.com/silverstripe/sapphire/commit/678232f) Add reference for  template documentation (Will Rossiter)
 * 2012-08-30 [898f9ad](https://github.com/silverstripe/sapphire/commit/898f9ad) DOC Gave easier instructions for would-be authors (Sam Minnée)
 * 2012-08-29 [d9243cd](https://github.com/silverstripe/silverstripe-cms/commit/d9243cd) FIX Pages with obsolete class shouldnt do first versionless write (Hamish Friedlander)
 * 2012-08-29 [2f00884](https://github.com/silverstripe/sapphire/commit/2f00884) FIX If ClassName read from DB doesnt exist, dont break (Hamish Friedlander)
 * 2012-08-29 [09e3fa4](https://github.com/silverstripe/sapphire/commit/09e3fa4) Removed pre-emptive dev/build from travis test run, to make it faster. (Sam Minnee)
 * 2012-08-29 [362e979](https://github.com/silverstripe/silverstripe-cms/commit/362e979) Replace tutorial link (Naomi Guyer)
 * 2012-08-29 [05fade3](https://github.com/silverstripe/sapphire/commit/05fade3) FIX 7763 TreeDropdownField needs to refresh after CMS edit form save (Hamish Friedlander)
 * 2012-08-28 [6162ae5](https://github.com/silverstripe/sapphire/commit/6162ae5) Fixed preview link ordering in CMS (Ingo Schommer)
 * 2012-08-28 [b53790e](https://github.com/silverstripe/sapphire/commit/b53790e) Fluent API for PaginatedList (Ingo Schommer)
 * 2012-08-28 [4369727](https://github.com/silverstripe/silverstripe-cms/commit/4369727) Enable page sorting by Page name in list view (see #7601) (Saophalkun Ponlu)
 * 2012-08-28 [e595b8f](https://github.com/silverstripe/sapphire/commit/e595b8f) GridFieldSortableHeader now allows composite fields to be sorted based db fields (see #7601) (Saophalkun Ponlu)
 * 2012-08-28 [62cfd87](https://github.com/silverstripe/silverstripe-cms/commit/62cfd87) FIX 7819 Check if the current folder ID is in the url before assuming the list should not filter by folder ID (jean)
 * 2012-08-28 [2637e6d](https://github.com/silverstripe/silverstripe-cms/commit/2637e6d) FIX Dont refer to framework module in config rules (Hamish Friedlander)
 * 2012-08-28 [26cfd64](https://github.com/silverstripe/sapphire/commit/26cfd64) FIX issue with cyclic configs when framework called sapphire (Hamish Friedlander)
 * 2012-08-28 [d45dd34](https://github.com/silverstripe/silverstripe-cms/commit/d45dd34) FIX VirtualPageTest failing on apps with no $db on Page (Hamish Friedlander)
 * 2012-08-28 [aa0cd14](https://github.com/silverstripe/sapphire/commit/aa0cd14) FIX Make config DAG error message more dev friendly (Hamish Friedlander)
 * 2012-08-28 [cbadd3e](https://github.com/silverstripe/silverstripe-cms/commit/cbadd3e) FIX Config frag legacycmsroutes doesnt need to come after _everything_ (Hamish Friedlander)
 * 2012-08-28 [2f64381](https://github.com/silverstripe/sapphire/commit/2f64381) LeftAndMain::$session_namespace (Ingo Schommer)
 * 2012-08-27 [5a44ea2](https://github.com/silverstripe/sapphire/commit/5a44ea2) Deselect tree nodes when reacting to form load event (fixes #7401) (Ingo Schommer)
 * 2012-08-27 [11b85e9](https://github.com/silverstripe/silverstripe-cms/commit/11b85e9) Fixed "from"/"to" filter field widths (Ingo Schommer)
 * 2012-08-27 [4a8236f](https://github.com/silverstripe/sapphire/commit/4a8236f) Removed special "from"/"to" filter field CSS rules (Ingo Schommer)
 * 2012-08-27 [e4db3c6](https://github.com/silverstripe/sapphire/commit/e4db3c6) Removed DateField special width with .hasDatepicker class (Ingo Schommer)
 * 2012-08-27 [76dd8cc](https://github.com/silverstripe/sapphire/commit/76dd8cc) Remove width limit on CMS panel dropdowns (Ingo Schommer)
 * 2012-08-27 [88dfde8](https://github.com/silverstripe/sapphire/commit/88dfde8) Removed arbitrary width restrictions on field group children (Ingo Schommer)
 * 2012-08-27 [dddc5bd](https://github.com/silverstripe/sapphire/commit/dddc5bd) Removed accidental *.orig files (Ingo Schommer)
 * 2012-08-27 [8b6e4f5](https://github.com/silverstripe/sapphire/commit/8b6e4f5) Add some basic tests for ConfigManifest#relativeOrder (Hamish Friedlander)
 * 2012-08-27 [e0b8f15](https://github.com/silverstripe/sapphire/commit/e0b8f15) FIX Config wasnt filtering wildcards properly (Hamish Friedlander)
 * 2012-08-27 [c7ca47f](https://github.com/silverstripe/sapphire/commit/c7ca47f) FIX Config frag could only have one before or after rule (Hamish Friedlander)
 * 2012-08-27 [9b6216d](https://github.com/silverstripe/sapphire/commit/9b6216d) FIXED: Error in test case deprecation (Damian Mooyman)
 * 2012-08-27 [0a6a3fa](https://github.com/silverstripe/sapphire/commit/0a6a3fa) i18n for file type descriptors (see #7798) (Ingo Schommer)
 * 2012-08-26 [8dccb7f](https://github.com/silverstripe/sapphire/commit/8dccb7f) i18n for GridField pagination footer (see #7798) (Ingo Schommer)
 * 2012-08-26 [8442ed0](https://github.com/silverstripe/silverstripe-cms/commit/8442ed0) i18n for report table title (see #7798) (Ingo Schommer)
 * 2012-08-26 [2fab657](https://github.com/silverstripe/sapphire/commit/2fab657) i18n for CMS section titles (see #7798) (Ingo Schommer)
 * 2012-08-26 [3b59212](https://github.com/silverstripe/sapphire/commit/3b59212) i18n for "select an anchor" string (see #7798) (Ingo Schommer)
 * 2012-08-26 [59546cc](https://github.com/silverstripe/silverstripe-cms/commit/59546cc) Localized page name in "add page" dialog and dropdowns (see #7798) (Ingo Schommer)
 * 2012-08-26 [6b6dfae](https://github.com/silverstripe/silverstripe-cms/commit/6b6dfae) Fixed i18n namespace for "Sync Files" (Ingo Schommer)
 * 2012-08-24 [14759b6](https://github.com/silverstripe/sapphire/commit/14759b6) FIX #7787 Handles ajax and normal requests differently when validation fails on gridfields (jean)
 * 2012-08-23 [d20eae4](https://github.com/silverstripe/silverstripe-cms/commit/d20eae4) Updated translations (Ingo Schommer)
 * 2012-08-23 [0aa2894](https://github.com/silverstripe/sapphire/commit/0aa2894) Updated translations (Ingo Schommer)
 * 2012-08-22 [3e07822](https://github.com/silverstripe/sapphire/commit/3e07822) Allow scheme-relative URLs in requirements (Fred Condo)
 * 2012-08-22 [9ebac90](https://github.com/silverstripe/sapphire/commit/9ebac90) Removed 'relation filters' from datamodel docs (Ingo Schommer)
 * 2012-08-21 [e159a68](https://github.com/silverstripe/sapphire/commit/e159a68) FIX Removes version checking for LSB in Object::static_lookup() (Simon Welsh)
 * 2012-08-21 [f6334dd](https://github.com/silverstripe/sapphire/commit/f6334dd) Added default sort to test data for better cross-db performance. (Sam Minnee)
 * 2012-08-21 [d0bc9c6](https://github.com/silverstripe/sapphire/commit/d0bc9c6) FIX Hierarchy#liveChildren couldnt handle lots of pages (Hamish Friedlander)
 * 2012-08-21 [7807842](https://github.com/silverstripe/silverstripe-cms/commit/7807842) FIXED: Additional issue where the add-page ajax parameters wouldu incorrectly concatenate additional query parameters into the add action url. Resolved by moving URL concatenation from view to controller where Controller::join_links is available (Damian Mooyman)
 * 2012-08-21 [f7ffb79](https://github.com/silverstripe/sapphire/commit/f7ffb79) FIXED: Compatibility fixes for MS SQL Server. Replaced back ticks (which are mysql specific) with double quotes (Damian Mooyman)
 * 2012-08-21 [abbce15](https://github.com/silverstripe/sapphire/commit/abbce15) Updated Travis-CI configuration to have a 4 build grid. (Sam Minnee)
 * 2012-08-20 [2e791ab](https://github.com/silverstripe/silverstripe-cms/commit/2e791ab) Better i18n for "new page" label (fixes #7796) (Ingo Schommer)
 * 2012-08-20 [e6e2ab4](https://github.com/silverstripe/silverstripe-cms/commit/e6e2ab4) Updated translations (Ingo Schommer)
 * 2012-08-20 [f0340e6](https://github.com/silverstripe/sapphire/commit/f0340e6) Updated translations (Ingo Schommer)
 * 2012-08-20 [c019f22](https://github.com/silverstripe/silverstripe-cms/commit/c019f22) Fix notice when ErrorPage tries to create static error pages and can't write (Sean Harvey)
 * 2012-08-20 [89728ac](https://github.com/silverstripe/sapphire/commit/89728ac) UPDATED: Improved get_all_versions test case to test versions in the middle of version updates. (Damian Mooyman)
 * 2012-08-20 [56fe7f8](https://github.com/silverstripe/sapphire/commit/56fe7f8) REMOVED: Unnecessary publish actions from test cases ADDED: Test case for get_all_versions (Damian Mooyman)
 * 2012-08-20 [0f09305](https://github.com/silverstripe/sapphire/commit/0f09305) FIXED: Issue where temporary table would cause unpredictable behaviour. Temporary table functionality was substituted with subqueries in each use case. ADDED: Test case for version archive functionality. (Damian Mooyman)
 * 2012-08-16 [4727523](https://github.com/silverstripe/sapphire/commit/4727523) Added correct CSS class to GroupedDropdownField (Ingo Schommer)
 * 2012-08-16 [f5007a5](https://github.com/silverstripe/silverstripe-cms/commit/f5007a5) Allow extension of "add" link in CMS (Ingo Schommer)
 * 2012-08-16 [b560d25](https://github.com/silverstripe/sapphire/commit/b560d25) Re-enable Entwine Inspector in CMS & document (Hamish Friedlander)
 * 2012-08-16 [915ae1a](https://github.com/silverstripe/sapphire/commit/915ae1a) Upgrade entwine to latest (Hamish Friedlander)
 * 2012-08-15 [701da8b](https://github.com/silverstripe/sapphire/commit/701da8b) Updated translations; i18n for fieldLabels (Roland Lehmann)
 * 2012-08-14 [fe14346](https://github.com/silverstripe/sapphire/commit/fe14346) Revert "Make PHPUnit bootstrap add flush=1" (Sam Minnee)
 * 2012-08-14 [2c62dda](https://github.com/silverstripe/sapphire/commit/2c62dda) Fixed Travis CI and make it use SQLite (Sam Minnee)
 * 2012-08-14 [e003796](https://github.com/silverstripe/sapphire/commit/e003796) Make PHPUnit bootstrap add flush=1 (Sam Minnee)
 * 2012-08-14 [b952211](https://github.com/silverstripe/sapphire/commit/b952211) Fixed bugs in Travis CI set-up (Sam Minnee)
 * 2012-08-14 [04e3bed](https://github.com/silverstripe/sapphire/commit/04e3bed) Added support for Travis CI (Sam Minnee)
 * 2012-08-13 [ec89832](https://github.com/silverstripe/sapphire/commit/ec89832) Registering Te Reo support in i18n (Ingo Schommer)
 * 2012-08-13 [7170eb7](https://github.com/silverstripe/sapphire/commit/7170eb7) Localized parts of TinyMCE into Te Reo (Ingo Schommer)
 * 2012-08-13 [857afc4](https://github.com/silverstripe/sapphire/commit/857afc4) Localization for custom TinyMCE ssmacron module (Ingo Schommer)
 * 2012-08-12 [e486a16](https://github.com/silverstripe/silverstripe-cms/commit/e486a16) "Edit tree" button alignment (Ingo Schommer)
 * 2012-08-12 [94b739e](https://github.com/silverstripe/sapphire/commit/94b739e) Updated translations (Ingo Schommer)
 * 2012-08-12 [82699ba](https://github.com/silverstripe/silverstripe-cms/commit/82699ba) Updated translations (Ingo Schommer)
 * 2012-08-10 [c55b018](https://github.com/silverstripe/sapphire/commit/c55b018) FIXED: Issue where versioned would join _versions tables on ID,Version instead of RecordID,Version (Damian Mooyman)
 * 2012-08-10 [22c5f31](https://github.com/silverstripe/sapphire/commit/22c5f31) FIXED: Issue where viewing an archived version of a page caused invalid SQL to be generated. This would only occur with subclasses of Page. (Damian Mooyman)
 * 2012-08-10 [023721a](https://github.com/silverstripe/sapphire/commit/023721a) GridFieldPaginator localization (Ingo Schommer)
 * 2012-08-10 [c7fd9a6](https://github.com/silverstripe/sapphire/commit/c7fd9a6) CMS Localization (Ingo Schommer)
 * 2012-08-09 [77d939f](https://github.com/silverstripe/sapphire/commit/77d939f) CMS Localization (Ingo Schommer)
 * 2012-08-09 [68855a2](https://github.com/silverstripe/sapphire/commit/68855a2) Guard against double inclusion of phpunit (Ingo Schommer)
 * 2012-08-09 [186d95c](https://github.com/silverstripe/sapphire/commit/186d95c) Argument optional in collectFromEntityProviders() (Ingo Schommer)
 * 2012-08-09 [d172e16](https://github.com/silverstripe/sapphire/commit/d172e16) FIXED: Bug in GridFieldAddExistingAutocompleter.php where an uninitialised variable would occasionally crash searches REMOVED: Unused variable (Damian Mooyman)
 * 2012-08-09 [a80daef](https://github.com/silverstripe/sapphire/commit/a80daef) FIXED: Issue where urls with querystring arguments would not be properly concatenated with additional query parameters during ajax requests. The behaviour would not normally be noted except when using a module (such as Translatable) that adds parameters to data-url fields in forms. (Damian Mooyman)
 * 2012-08-08 [b1ee36e](https://github.com/silverstripe/sapphire/commit/b1ee36e) Fix: display the correct (menu) icon in the GridFieldDetailForm's breadcrumbs. (martimiz)
 * 2012-08-08 [342f076](https://github.com/silverstripe/sapphire/commit/342f076) Revert "NEW add selectsession URL endpoint" (Ingo Schommer)
 * 2012-08-08 [a6087f1](https://github.com/silverstripe/silverstripe-cms/commit/a6087f1) FIXED: Issue where links within the CMS page list view would not be correctly generated. E.g. when the translatable module is used, page links for the "show children" action would come up as admin/pages/?locale=en_NZ?ParentID=21&view=list when they should be shows as admin/pages/?locale=en_NZ&ParentID=21&view=list. Uses Controller::join_links to perform the necessary sanity check on urls. (Damian Mooyman)
 * 2012-08-07 [8d9db7f](https://github.com/silverstripe/sapphire/commit/8d9db7f) FIX: Proper buttonset styling (dd1079)
 * 2012-08-07 [ae52be5](https://github.com/silverstripe/sapphire/commit/ae52be5) FIX: Missing last login time (fixes 7666) (Naomi Guyer)
 * 2012-08-07 [3481297](https://github.com/silverstripe/sapphire/commit/3481297) FIX 7742 Decode the URI encoded attribute before displaying it as the value for the tree dropdown (jean)
 * 2012-08-06 [342ecd9](https://github.com/silverstripe/silverstripe-cms/commit/342ecd9) Removed custom entities from master file (Ingo Schommer)
 * 2012-08-06 [9b15bac](https://github.com/silverstripe/sapphire/commit/9b15bac) Parameter omission in i18nTextCollector (Ingo Schommer)
 * 2012-08-06 [2276336](https://github.com/silverstripe/silverstripe-cms/commit/2276336) Maori translation of URLSegment JS UI (Ingo Schommer)
 * 2012-08-06 [635c05b](https://github.com/silverstripe/silverstripe-cms/commit/635c05b) URLSegment JS UI globalization (Ingo Schommer)
 * 2012-08-06 [7e33fac](https://github.com/silverstripe/silverstripe-cms/commit/7e33fac) Updated translations (Ingo Schommer)
 * 2012-08-06 [8320e4e](https://github.com/silverstripe/sapphire/commit/8320e4e) Updated translations (Ingo Schommer)
 * 2012-08-06 [671c7da](https://github.com/silverstripe/silverstripe-cms/commit/671c7da) SiteConfig load/save with ID in CMS (Ingo Schommer)
 * 2012-08-05 [9076286](https://github.com/silverstripe/silverstripe-cms/commit/9076286) SiteTree-&gt;CMSEditLink() (Ingo Schommer)
 * 2012-08-05 [0abef42](https://github.com/silverstripe/sapphire/commit/0abef42) Pointer to CMS architecture docs (Ingo Schommer)
 * 2012-08-05 [b4e3c13](https://github.com/silverstripe/sapphire/commit/b4e3c13) Improved tree docs (Ingo Schommer)
 * 2012-08-05 [bbbec35](https://github.com/silverstripe/sapphire/commit/bbbec35) Update ideal commit message to reflect new guidelines (Will Rossiter)
 * 2012-08-04 [00a2edd](https://github.com/silverstripe/sapphire/commit/00a2edd) Wrong deprecation notice in DBField::create() (Juerg Rast)
 * 2012-08-03 [6adc39e](https://github.com/silverstripe/sapphire/commit/6adc39e) Fixed example code in docs/en/topics/datamodel.md. (jakr)
 * 2012-08-03 [eb82094](https://github.com/silverstripe/sapphire/commit/eb82094) Datamodel documentation fixes (Will Rossiter)
 * 2012-08-03 [d774cb5](https://github.com/silverstripe/sapphire/commit/d774cb5) Add nowrap to buttons to ensure single lines (https://skitch.com/willrossi/ekp44/silverstripe-pages). Thanks oetiker (Will Rossiter)
 * 2012-08-01 [fa67106](https://github.com/silverstripe/sapphire/commit/fa67106) Update javascript/lang/de_DE.js (dd1079)
 * 2012-08-01 [90b0fe8](https://github.com/silverstripe/sapphire/commit/90b0fe8) FIX Only reload data for a item edited through a GridField if the record exists. Fix 7721 (jean)
 * 2012-08-01 [1900842](https://github.com/silverstripe/sapphire/commit/1900842) Make the list used for autocomplete search results settable. (Andrew Short)
 * 2012-07-31 [7558d32](https://github.com/silverstripe/sapphire/commit/7558d32) FIX: use standard template rendering process for RSS feeds (Will Rossiter)
 * 2012-07-31 [61862e3](https://github.com/silverstripe/silverstripe-cms/commit/61862e3) Added Swedish javascript translations (Niklas Forsdahl)
 * 2012-07-31 [2503e48](https://github.com/silverstripe/sapphire/commit/2503e48) Only initialise chosen elements when visible. (Andrew Short)
 * 2012-07-31 [b38735d](https://github.com/silverstripe/sapphire/commit/b38735d) Fix chosen dropdown width not being set. (Andrew Short)
 * 2012-07-31 [c1f27c1](https://github.com/silverstripe/sapphire/commit/c1f27c1) Revert b9ed6f7f6d388fc451efbada2d1501d667322cb0. (Andrew Short)
 * 2012-07-29 [4abe6be](https://github.com/silverstripe/sapphire/commit/4abe6be) The documentation about internationalization in templates in topics/i18n.md did not match how the parser works. Related to ticket #7706. (jakr)
 * 2012-07-28 [4848bec](https://github.com/silverstripe/sapphire/commit/4848bec) Removed duplicated 'return ' (Juerg Rast)
 * 2012-07-26 [ebc89ff](https://github.com/silverstripe/sapphire/commit/ebc89ff) Update docs/en/index.md (LiamW)
 * 2012-07-27 [72efed1](https://github.com/silverstripe/sapphire/commit/72efed1) Dont need to wrap entwine blocks in onload blocks, theres no benefit (Hamish Friedlander)
 * 2012-07-26 [37e8b09](https://github.com/silverstripe/sapphire/commit/37e8b09) Update the IIS7 folder permission configuration docs. (Mateusz Uzdowski)
 * 2012-07-24 [3bc2798](https://github.com/silverstripe/sapphire/commit/3bc2798) Fix edge case in sessionStorage detection for FireFox. If it is disabled using about:config, typeof will be object, but the value will be null. (jakr)
 * 2012-07-20 [0308cc2](https://github.com/silverstripe/sapphire/commit/0308cc2) Tutorial 2/3 and some howto tweaks (Ingo Schommer)
 * 2012-07-19 [6d8976e](https://github.com/silverstripe/sapphire/commit/6d8976e) Forms, navigation howto plus adjustments to tutorial one (#6367 ) (Naomi Guyer)
 * 2012-07-09 [e0c92f1](https://github.com/silverstripe/silverstripe-cms/commit/e0c92f1) Display of last edit date should be exact to the minute. (Devlin)
 * 2012-07-05 [aeb279b](https://github.com/silverstripe/silverstripe-installer/commit/aeb279b) Ignore git subcheckouts (Sam Minnee)
 * 2012-07-05 [4c00b45](https://github.com/silverstripe/silverstripe-installer/commit/4c00b45) Added demo site deploy script (Sam Minnee)
 * 2012-07-05 [1dfc722](https://github.com/silverstripe/silverstripe-installer/commit/1dfc722) Added frameworktest to demo site (Sam Minnee)
 * 2012-07-02 [2d80ea5](https://github.com/silverstripe/sapphire/commit/2d80ea5) Documentation, tutorial (part3, and tidy-up part 1&2 ) (Naomi Guyer)
 * 2012-06-29 [a58cb37](https://github.com/silverstripe/sapphire/commit/a58cb37) Fix TreeDropdownField toggle alignment in FF (Francisco arenas)
 * 2012-05-21 [b109824](https://github.com/silverstripe/silverstripe-installer/commit/b109824) Added code to run the demo site, and check out selected modules. (Sam Minnee)
