# 3.1.2-rc1

## Overview

 * Default current Versioned "stage" to "Live" rather than "Stage"
 * UploadField marks CMS forms as changed
 * Treedropdownfield shows search by default
 * Disable discontinued Google Spellcheck in TinyMCE, default to browser spellcheck
 * CMS switches to correct tab on validation errors
 * CMS tree scrolls to selected node automatically
 * New translations: Te Reo/Maori, Arabic, Chinese/Mandarin

## Upgrading

### Default current Versioned "stage" to "Live" rather than "Stage"

Previously only the controllers responsible for page and CMS display 
(`LeftAndMain` and `ContentController`) explicitly set a stage through
`Versioned::choose_site_stage()`. Unless this method is called,
the default stage will be "Stage", showing draft content.
Any direct subclasses of `Controller` interacting with "versioned" objects
are vulnerable to exposing unpublished content, unless `choose_site_stage()`
is called explicitly in their own logic.

In order to provide more secure default behaviour, we have changed
`choose_site_stage()` to be called on all requests, defaulting to the "Live" stage.
If your logic relies on querying draft content, use `Versioned::reading_stage('Stage')`.

Important: The `choose_site_stage()` call only deals with setting the default stage,
and doesn't check if the user is authenticated to view it. As with any other controller logic,
please use `DataObject->canView()` to determine permissions.

	:::php
	class MyController extends Controller {
		private static $allowed_actions = array('showpage');
		public function showpage($request) {
			$page = Page::get()->byID($request->param('ID'));
			if(!$page->canView()) return $this->httpError(401);
			// continue with authenticated logic...
		}
	}

### Treedropdownfield showsearch defaults to true
The showSearch option of TreedropdownField is now set to true by default. This is to provide a fallback ui for when children of a tree node fail to render (due to too many children). You may set search as false when initializing a TreedropdownField, or afterwards:

	:::php
	$treedropdownfield->setShowSearch(false);

If your data requires a specialized search function, you may specify it within:

	:::php
	$treedropdownfield->setSearchFunction();


### API Changes

 * 2013-10-24 [415f8a0](https://github.com/silverstripe/sapphire/commit/415f8a0) tracker allows explicit dirty messages BUG Fixed issue with UploadField not detecting changes (Damian Mooyman)
 * 2013-10-23 [dda1441](https://github.com/silverstripe/sapphire/commit/dda1441) TinyMCE contextmenu is disabled by default (colymba)
 * 2013-10-23 [b726180](https://github.com/silverstripe/silverstripe-cms/commit/b726180) JS i18n files with short locale names, generated by build task (Ingo Schommer)
 * 2013-10-23 [2c145cd](https://github.com/silverstripe/sapphire/commit/2c145cd) JS i18n files with short locale names, generated by build task (Ingo Schommer)
 * 2013-10-21 [32bb98b](https://github.com/silverstripe/sapphire/commit/32bb98b) DataObject-&gt;getRemoteJoinField() no longer defaults to ParentID but throws an exception instead (Zauberfisch)
 * 2013-10-09 [a339687](https://github.com/silverstripe/sapphire/commit/a339687) Pass extra context information to shortcode handlers. (Andrew Short)
 * 2013-10-02 [2d0a354](https://github.com/silverstripe/sapphire/commit/2d0a354) Add attributes argument for CMSMenuItem. (Will Rossiter)
 * 2013-09-24 [2b7a2a2](https://github.com/silverstripe/sapphire/commit/2b7a2a2) Escape form validation messages (SS-2013-008) (Ingo Schommer)
 * 2013-09-24 [c243418](https://github.com/silverstripe/sapphire/commit/c243418) Escape form validation messages (SS-2013-008) (Ingo Schommer)
 * 2013-08-29 [8b5f89f](https://github.com/silverstripe/sapphire/commit/8b5f89f) Treedropdownfield showsearch default true, provide better ui (Naomi Guyer)
 * 2013-08-22 [1f8feb5](https://github.com/silverstripe/sapphire/commit/1f8feb5) Provide a thin alternative to loadPanel/submitForm. (Mateusz Uzdowski)
 * 2013-08-03 [0e7231f](https://github.com/silverstripe/sapphire/commit/0e7231f) Disable discontinued Google Spellcheck in TinyMCE (Ingo Schommer)

### Features and Enhancements

 * 2013-10-23 [b6589ba](https://github.com/silverstripe/silverstripe-cms/commit/b6589ba) Page types no longer require a controller, they can inherit the parent page type's (Loz Calver)
 * 2013-10-19 [19928ff](https://github.com/silverstripe/sapphire/commit/19928ff) GDBackend can save interlaced image (colymba)
 * 2013-10-17 [ac418ce](https://github.com/silverstripe/sapphire/commit/ac418ce) to allow that changing the SSTemplateParser through the Injector system (Cam Spiers)
 * 2013-05-30 [6b3b618](https://github.com/silverstripe/sapphire/commit/6b3b618) Disable specific tree nodes in TreeDropdownField (Loz Calver)

### Bugfixes

 * 2013-11-01 [65b4407](https://github.com/silverstripe/sapphire/commit/65b4407) "Draft" stage to fix dev/build, Versioned docs (fixes #2619) (Ingo Schommer)
 * 2013-10-30 [4131f57](https://github.com/silverstripe/sapphire/commit/4131f57) backtrace now filters MySQLi arguments (colymba)
 * 2013-10-30 [22f5f4d](https://github.com/silverstripe/sapphire/commit/22f5f4d) Fix undefined index ID (Damian Mooyman)
 * 2013-10-25 [1a39f61](https://github.com/silverstripe/sapphire/commit/1a39f61) Fix the password reset message to be shown consistently. (Mateusz Uzdowski)
 * 2013-10-23 [e46bcf7](https://github.com/silverstripe/sapphire/commit/e46bcf7) Allow TreeDropdownField to open upwards (fixes #2188) (Loz Calver)
 * 2013-10-22 [112e08e](https://github.com/silverstripe/sapphire/commit/112e08e) Session::get_timeout (Devlin)
 * 2013-10-21 [2a6f1f1](https://github.com/silverstripe/sapphire/commit/2a6f1f1) #2496 `ConfirmedPasswordField` mismatch passwords saved (Daniel Hensby)
 * 2013-10-18 [371ccca](https://github.com/silverstripe/sapphire/commit/371ccca) Less misuse of error control operator (@) This is necessary to prevent get_last_error() from returning suppressed errors when retrieving values from nested arrays (Damian Mooyman)
 * 2013-10-17 [2495069](https://github.com/silverstripe/sapphire/commit/2495069) Fixes serious issue with FieldList::addFieldsToTab failing to accept multiple field groups. (Damian Mooyman)
 * 2013-10-17 [702b6c9](https://github.com/silverstripe/sapphire/commit/702b6c9) Fixed incorrect CSS class on MoneyField holder (Damian Mooyman)
 * 2013-10-16 [813d34b](https://github.com/silverstripe/sapphire/commit/813d34b) Use Injector API for managing Member_Validator instance. (Will Rossiter)
 * 2013-10-16 [69ae8a8](https://github.com/silverstripe/silverstripe-cms/commit/69ae8a8) Remove invalid single quote (Dawid Cieszyński)
 * 2013-10-16 [8801a50](https://github.com/silverstripe/sapphire/commit/8801a50) oembed to avoid mixed media issues (Hamish Friedlander)
 * 2013-10-15 [5ea314d](https://github.com/silverstripe/sapphire/commit/5ea314d) PasswordValidator-&gt;characterStrength() Documentation (Devlin)
 * 2013-10-15 [a1ad454](https://github.com/silverstripe/sapphire/commit/a1ad454) Changing `public` static `$priority` to `private` (Daniel Hensby)
 * 2013-10-15 [7bcb180](https://github.com/silverstripe/sapphire/commit/7bcb180) Director::test now calls RequestProcessor (Marcus Nyeholt)
 * 2013-10-12 [3f7b3fd](https://github.com/silverstripe/sapphire/commit/3f7b3fd) Fix tab state not being restored due to incorrect selector. (Andrew Short)
 * 2013-10-10 [b7476f2](https://github.com/silverstripe/silverstripe-cms/commit/b7476f2) Fix add new button not passing the correct parent ID. (Andrew Short)
 * 2013-10-09 [a63b9c9](https://github.com/silverstripe/sapphire/commit/a63b9c9) Fix not switching to the correct tab on validation error. (Andrew Short)
 * 2013-10-09 [ed9f8dc](https://github.com/silverstripe/sapphire/commit/ed9f8dc) Fix CMS forms with validation errors responding incorrectly. (Andrew Short)
 * 2013-10-07 [75f2b17](https://github.com/silverstripe/sapphire/commit/75f2b17) gridfield delete alert selector specificity (colymba)
 * 2013-10-04 [dd49834](https://github.com/silverstripe/sapphire/commit/dd49834) Fixing installer not checking display_errors correctly. (Sean Harvey)
 * 2013-10-04 [156bb87](https://github.com/silverstripe/sapphire/commit/156bb87) Move stage choosing into a pre-request filter. (Andrew Short)
 * 2013-10-04 [e7c8fed](https://github.com/silverstripe/sapphire/commit/e7c8fed) Move stage choosing into a pre-request filter. (Andrew Short)
 * 2013-10-03 [66bfff4](https://github.com/silverstripe/silverstripe-cms/commit/66bfff4) Don't validate pages when restoring or reverting (fixes #2449) (Loz Calver)
 * 2013-10-03 [5bbea12](https://github.com/silverstripe/sapphire/commit/5bbea12) Issue with login form failing to login in certain situations. Fixes issue #2424 (Damian Mooyman)
 * 2013-10-03 [4b850fb](https://github.com/silverstripe/sapphire/commit/4b850fb) Fixed cross-platform issues with test cases and file utilities (Damian Mooyman)
 * 2013-10-03 [f67b549](https://github.com/silverstripe/sapphire/commit/f67b549) Fixed cross-platform issues with test cases and file utilities (Damian Mooyman)
 * 2013-10-03 [0d2d293](https://github.com/silverstripe/silverstripe-cms/commit/0d2d293) check if hints are defined for given pagetype before using. Fixes #861 (Shea Dawson)
 * 2013-10-03 [afaf7f6](https://github.com/silverstripe/sapphire/commit/afaf7f6) Sort column order maintained correctly when using expressions in SQLQuery and DataQuery (Damian Mooyman)
 * 2013-10-02 [9b0564b](https://github.com/silverstripe/sapphire/commit/9b0564b) Undefined variable in TreeDropdownField.php (Loz Calver)
 * 2013-10-01 [daf92e6](https://github.com/silverstripe/silverstripe-cms/commit/daf92e6) ReportAdmin report links regression (Ingo Schommer)
 * 2013-09-30 [d79d507](https://github.com/silverstripe/sapphire/commit/d79d507) Make CreditCardField use template (Tom Densham)
 * 2013-09-27 [b1ad10a](https://github.com/silverstripe/sapphire/commit/b1ad10a) Without casting TreeTitle as HTMLText, unescape HTML appears in TreeDropdownField (unclecheese)
 * 2013-09-24 [f3ef04a](https://github.com/silverstripe/sapphire/commit/f3ef04a) Auto-escape titles in TreeDropdownField (Ingo Schommer)
 * 2013-09-24 [114fb59](https://github.com/silverstripe/sapphire/commit/114fb59) Auto-escape titles in TreeDropdownField (Ingo Schommer)
 * 2013-09-24 [e170f4c](https://github.com/silverstripe/silverstripe-cms/commit/e170f4c) Escaping in "dependent pages" (SS-2013-009) (Ingo Schommer)
 * 2013-09-24 [78ce99b](https://github.com/silverstripe/sapphire/commit/78ce99b) Escape breadcrumbs in SecurityAdmin (SS-2013-007) (Ingo Schommer)
 * 2013-09-20 [b1f03db](https://github.com/silverstripe/sapphire/commit/b1f03db) Improve recent RestfulService fix for proxies (Hamish Friedlander)
 * 2013-09-20 [7ddd5b5](https://github.com/silverstripe/sapphire/commit/7ddd5b5) Do not rely on broken curl header size calculation. (Mateusz Uzdowski)
 * 2013-09-20 [a8c1dd7](https://github.com/silverstripe/sapphire/commit/a8c1dd7) Use last of duplicate query params in join_links (Hamish Friedlander)
 * 2013-09-20 [b383a07](https://github.com/silverstripe/sapphire/commit/b383a07) Fixing tabindex added to CreditCardField when tabindex is NULL (Sean Harvey)
 * 2013-09-20 [c453ea3](https://github.com/silverstripe/sapphire/commit/c453ea3) Fixing tabindex added to CreditCardField when tabindex is NULL (Sean Harvey)
 * 2013-09-19 [de10471](https://github.com/silverstripe/sapphire/commit/de10471) added &lt;param&gt; tag to ContentNegotiator filtering (g4b0)
 * 2013-09-16 [6377855](https://github.com/silverstripe/sapphire/commit/6377855) Follow internal redirections for cli operations. (Will Rossiter)
 * 2013-09-13 [3aaa12f](https://github.com/silverstripe/sapphire/commit/3aaa12f) Fixes #2398 - hasAmount() failed to return true for values &lt;= 0.99 and &gt;= 0.01 - Added unit tests (Russell Michell)
 * 2013-09-11 [6979726](https://github.com/silverstripe/sapphire/commit/6979726) TreeDropdownField remove call to get value on search (Naomi Guyer)
 * 2013-09-06 [95bb799](https://github.com/silverstripe/sapphire/commit/95bb799) Fixing SQLQuery::aggregate() adding ORDER BY when no limit. (Sean Harvey)
 * 2013-09-06 [abcb2ef](https://github.com/silverstripe/sapphire/commit/abcb2ef) Modified fix for #2389 to ensure existing tests pass. (Russell Michell)
 * 2013-09-05 [128c33b](https://github.com/silverstripe/sapphire/commit/128c33b) Fixes #2389 - Prevent circular references in `GridFieldAddExistingAutocompleter` when linking DataObjects whose ID matches the current object to which the gridfield is attached. (Russell Michell)
 * 2013-09-04 [52ef14a](https://github.com/silverstripe/sapphire/commit/52ef14a) Image resize allows skewing of image in IE (fixes CMS #791) (Naomi Guyer)
 * 2013-09-02 [a1b04cb](https://github.com/silverstripe/sapphire/commit/a1b04cb) Issue #2375 - UploadField showed 2 descriptions in CMS with one call to setDescription(). - Removed UploadField-specific template ref to $Description, in favour of using the "default" in FormField_holder.ss (Russell Michell)
 * 2013-08-30 [f803704](https://github.com/silverstripe/sapphire/commit/f803704) Disallow permissions assign for APPLY_ROLES (SS-2013-005) (Ingo Schommer)
 * 2013-08-30 [05757ef](https://github.com/silverstripe/sapphire/commit/05757ef) Privilege escalation through APPLY_ROLES assignment (SS-2013-005) (Ingo Schommer)
 * 2013-08-30 [6cff967](https://github.com/silverstripe/sapphire/commit/6cff967) Privilege escalation through Group and Member CSV upload (SS-2013-004) (Ingo Schommer)
 * 2013-08-30 [720c149](https://github.com/silverstripe/sapphire/commit/720c149) Privilege escalation through Group hierarchy setting (SS-2013-003) (Ingo Schommer)
 * 2013-08-29 [4f30fed](https://github.com/silverstripe/silverstripe-cms/commit/4f30fed) GridField button styling in reports (Tom Densham)
 * 2013-08-29 [5f82814](https://github.com/silverstripe/silverstripe-cms/commit/5f82814) Fixed instances of loosely defined SQL predicates not qualified by table name Fixed duplicate SQL escaping on SiteTree::get_by_link (Damian Mooyman)
 * 2013-08-28 [9ba92a7](https://github.com/silverstripe/silverstripe-cms/commit/9ba92a7) SiteConfig scrollbars visible (Arno Poot)
 * 2013-08-26 [b8495da](https://github.com/silverstripe/sapphire/commit/b8495da) Cached images stored in wrong folder (Johannes Hammersen, x75)
 * 2013-08-26 [65ad510](https://github.com/silverstripe/sapphire/commit/65ad510) fixed grammatical errors and formatting issues (jbridson)
 * 2013-08-24 [2df060e](https://github.com/silverstripe/sapphire/commit/2df060e) Make sure that debug always shows up first (Arno Poot)
 * 2013-08-23 [0f1ae7a](https://github.com/silverstripe/sapphire/commit/0f1ae7a) - Fixes issue with CMS permissions checkbox, which won't un-toggle checked-checkboxes, after being clicked a 2nd time (Russell Michell)
 * 2013-08-20 [e6b06ca](https://github.com/silverstripe/sapphire/commit/e6b06ca) Context menu too long - CSS only (Fixes CMS #811) (Naomi Guyer)
 * 2013-08-15 [537ee24](https://github.com/silverstripe/sapphire/commit/537ee24) Added _config as valid module folder in TextCollector (Arno Poot)
 * 2013-08-14 [6bb9386](https://github.com/silverstripe/sapphire/commit/6bb9386) Updating old reference of sapphire to framework (Kirk Mayo)
 * 2013-08-12 [090f07d](https://github.com/silverstripe/sapphire/commit/090f07d) Apply HTML5 required attributes when fields are required. (Mateusz Uzdowski)
 * 2013-08-09 [085d2e6](https://github.com/silverstripe/sapphire/commit/085d2e6) MemberLoginForm fields should be tagged as required. (Mateusz Uzdowski)
 * 2013-08-07 [a2a4957](https://github.com/silverstripe/silverstripe-cms/commit/a2a4957) Context menu too long (Fixes #811) (Naomi Guyer)
 * 2013-08-05 [1e5679f](https://github.com/silverstripe/sapphire/commit/1e5679f) i18n module load order in i18n::include_by_locale() (Devlin)
 * 2013-08-05 [65d96e8](https://github.com/silverstripe/sapphire/commit/65d96e8) Remove limit on GridField export (Will Rossiter)
 * 2013-07-28 [fefb7af](https://github.com/silverstripe/sapphire/commit/fefb7af) Fieldgroup styling (Arno Poot)
 * 2013-07-17 [9d764d6](https://github.com/silverstripe/sapphire/commit/9d764d6) Avoid infinite loops on ?isDev=1 and Deprecation class (Ingo Schommer)
 * 2013-07-12 [c74f7e7](https://github.com/silverstripe/sapphire/commit/c74f7e7) Fixes issue where items could be deleted from a has_many relation by an entirely unrelated HasManyList calling delete on that item. (Damian Mooyman)
 * 2013-07-09 [dbb2efc](https://github.com/silverstripe/sapphire/commit/dbb2efc) wrong class name being returned (Jeremy Thomerson)
 * 2013-06-28 [e225cff](https://github.com/silverstripe/sapphire/commit/e225cff) Empty Datefield with defined min or max has non-object error thrown (Daniel Hensby)
 * 2013-06-21 [3596892](https://github.com/silverstripe/sapphire/commit/3596892) GridField button styling (Tom Densham)
