# 3.1.7-rc1

## Upgrading

### Authentication

3.1.7 introduces a re-authentication feature, which allows user working in the CMS to quickly re-enter their password
and continue working should their session expire. This occurs through a popup dialog, which asks the user for their
current password to continue working.

If using a custom `[api:Authenticator]` class to replace the default MemberAuthenticator, then by default this feature
will be disabled. If multiple authenticators are used, only supported ones will be available within the CMS.

In order to create a CMS supported version the `Authenticator::supports_cms` and `Authenticator::get_cms_login_form`
methods should be overridden. See `[api:MemberAuthenticator]` for an example implementation.

Check the documentation at the [Authentication](/topics/authentication) topic.

### Default Admin

In this version the way that the default admin user is managed is slightly changed. Rather than defaulting to the first
administrator user in the CMS, a user logging in as a default admin will always be assigned to a "Default Admin"
user with admin privileges. In the past, this user would only be created if no other administrators existed.

## Security

This release includes only minor security related patches.

 * 2014-07-05 [c247dd5](https://github.com/silverstripe/silverstripe-framework/commit/c247dd5) Add default $lock_out_after_incorrect_logins value [SS-2014-016](http://www.silverstripe.org/software/download/security-releases/ss-2014-016).
 * 2014-10-24 [5d27ea4](https://github.com/silverstripe/sapphire/commit/5d27ea4) File attach handler is no longer accessible if attachment is disallowed or disabled [SS-2014-014](http://www.silverstripe.org/software/download/security-releases/ss-2014-014-front-end-uploadfield-exposes-lists-of-assets).

### API Changes

 * 2014-10-06 [53c40a9](https://github.com/silverstripe/sapphire/commit/53c40a9) Enable re-authentication within the CMS if a user session is lost BUG Resolve issue with error redirection being ignored within CMS BUG Fix issue with invalid securityID being re-emitted on failure (Damian Mooyman)
 * 2014-08-18 [920978d](https://github.com/silverstripe/sapphire/commit/920978d) Add ClassInfo::table_for_object_field (Will Rossiter)
 * 2014-06-01 [8fb5e9c](https://github.com/silverstripe/sapphire/commit/8fb5e9c) New JS sprintf and inject replacement functions (colymba)
 * 2013-12-05 [b273f3b](https://github.com/silverstripe/sapphire/commit/b273f3b) Updated aspect proxy service (Marcus Nyeholt)
 * 2013-12-05 [b8f4576](https://github.com/silverstripe/sapphire/commit/b8f4576) Use injector to create database class (Marcus Nyeholt)

### Features and Enhancements

 * 2014-08-16 [2b316e7](https://github.com/silverstripe/sapphire/commit/2b316e7) Provide a consistent way of triggering flush (Sean Harvey)
 * 2014-08-13 [62f4fdb](https://github.com/silverstripe/sapphire/commit/62f4fdb) Sanitise task name in runTask (Kirk Mayo)

### Bugfixes

 * 2014-11-03 [56142b8](https://github.com/silverstripe/silverstripe-cms/commit/56142b8) sprintf missing on exception in SilverStripeNavigator (Sean Harvey)
 * 2014-10-30 [392ddef](https://github.com/silverstripe/sapphire/commit/392ddef) Image resizing breaks when one of the resized image dimensions is between 0 and 1. Solution: Round up to 1 instead of down to 0. Converted php errors to exceptions in the process. (Jeremy Shipman)
 * 2014-10-23 [d6e1c51](https://github.com/silverstripe/sapphire/commit/d6e1c51) Prevent JSON response showing when re-opening closed tab (fixes silverstripe/silverstripe-cms#1121) (Loz Calver)
 * 2014-10-21 [478edfa](https://github.com/silverstripe/sapphire/commit/478edfa) Upload: File versioning with existing files reinsert oldFilePath = relativeFilePath in while loop (Devlin)
 * 2014-10-20 [49cb38d](https://github.com/silverstripe/sapphire/commit/49cb38d) Fix static call to protected instance method (Damian Mooyman)
 * 2014-10-20 [8310135](https://github.com/silverstripe/silverstripe-cms/commit/8310135) Broken links on dependent pages tab (micmania1)
 * 2014-10-17 [20af30e](https://github.com/silverstripe/sapphire/commit/20af30e) GridFieldExportButton exporting only Paginated list when using ArrayList as source (Stephen McMahon)
 * 2014-10-15 [570f261](https://github.com/silverstripe/sapphire/commit/570f261) Tag-less cache backends error on flush (Loz Calver)
 * 2014-10-14 [793784e](https://github.com/silverstripe/sapphire/commit/793784e) Fix flushing of SSViewer cache via testing (Damian Mooyman)
 * 2014-10-09 [bad9aa1](https://github.com/silverstripe/sapphire/commit/bad9aa1) i18n support in LookupField (Milan Jelicanin)
 * 2014-10-07 [48eb0e6](https://github.com/silverstripe/sapphire/commit/48eb0e6) Deliberately clear partial cache blocks on flush (fixes #1383) (Loz Calver)
 * 2014-10-01 [776f697](https://github.com/silverstripe/sapphire/commit/776f697) Text::BigSummary() fails with undefined $data when $plain = false (Sean Harvey)
 * 2014-09-03 [fe42abc](https://github.com/silverstripe/sapphire/commit/fe42abc) CSSContentParser fails if CLI tidy doesn't output anything. (Sean Harvey)
 * 2014-09-03 [56d84d2](https://github.com/silverstripe/sapphire/commit/56d84d2) MySQLDatabase performs queries on wrong DB connection when using connection $name != 'default' (Damian Mooyman)
 * 2014-08-26 [cf456d6](https://github.com/silverstripe/sapphire/commit/cf456d6) use @param $colName in column call (Gabrijel Gavranović)
 * 2014-08-26 [7993875](https://github.com/silverstripe/sapphire/commit/7993875) Sorting a DataQuery over a relation. (Will Rossiter)
 * 2014-08-22 [8063b34](https://github.com/silverstripe/sapphire/commit/8063b34) Fixing Director::test() failing on BASE_URL prefixed URLs (Sean Harvey)
 * 2014-08-20 [61c6dee](https://github.com/silverstripe/sapphire/commit/61c6dee) Fixing plural_name messing up singular words ending in "e" (#3251) (Sean Harvey)
 * 2014-08-15 [79c7276](https://github.com/silverstripe/sapphire/commit/79c7276) Reapply fix for cms crashing due to History.js blindly appending slashes to end of url (Damian Mooyman)
 * 2014-08-14 [5f1552b](https://github.com/silverstripe/sapphire/commit/5f1552b) Custom label set in summary_fields config gets overridden (Sean Harvey)
 * 2014-08-14 [7c2eee1](https://github.com/silverstripe/sapphire/commit/7c2eee1) Fix 'undefined index 0' (Damian Mooyman)
 * 2014-08-11 [69de7e3](https://github.com/silverstripe/sapphire/commit/69de7e3) Fix incorrect parsing of HTML content (Damian Mooyman)
 * 2014-08-08 [fbc7e7c](https://github.com/silverstripe/sapphire/commit/fbc7e7c) Fix issue with generating tree data for missing pages (Damian Mooyman)
 * 2014-07-28 [02265dc](https://github.com/silverstripe/sapphire/commit/02265dc) Correctly paddedResize images in IMagickBackend. FIX: Compression quality setting now takes effect. (Jeremy Shipman)
 * 2014-07-28 [47cc157](https://github.com/silverstripe/sapphire/commit/47cc157) Keep ImagickBackend  API consistent with Image_Backend interface and fix color formatting. (Jeremy Shipman)
 * 2014-07-28 [bf3ad56](https://github.com/silverstripe/sapphire/commit/bf3ad56) Image_Backend -&gt; croppedResize function doesn't include a backgroundColor, therefore this shouldn't be assumed in ImageMagick-&gt;croppedResize (Jeremy Shipman)
 * 2014-06-27 [19e0d5e](https://github.com/silverstripe/sapphire/commit/19e0d5e) declarations matching PHPUnit_Framework_Assert (Michael Parkhill)
 * 2014-03-12 [96d0874](https://github.com/silverstripe/sapphire/commit/96d0874) Fix issue with inheritance of Injector service configuration (Damian Mooyman)
 * 2014-01-31 [1661213](https://github.com/silverstripe/sapphire/commit/1661213) Opt-out pf form message escaping (fixes #2796) (Ingo Schommer)

## Changelog

 * [framework](https://github.com/silverstripe/silverstripe-framework/releases/tag/3.1.7-rc1)
 * [cms](https://github.com/silverstripe/silverstripe-cms/releases/tag/3.1.7-rc1)
 * [installer](https://github.com/silverstripe/silverstripe-installer/releases/tag/3.1.7-rc1)
