@extends('layouts.master')

@section('content')

@section('style')
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.6.3/css/all.css">
    <link rel="stylesheet" href="{{ URL::to('assets/css/checkbox-style.css') }}">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.4/css/jquery.dataTables.min.css">
    <style>
        .edit-btn {
            position: static;
        }
    </style>
@endsection

<div class="page-wrapper">
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-lists-center">
                <div class="col">
                    <h3 class="page-title">Clients</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Dashboard</a></li>
                        <li class="breadcrumb-item active">Clients</li>
                    </ul>
                </div>
                <div class="col-auto float-right ml-auto">
                    <a href="#" class="btn add-btn" data-toggle="modal" data-target="#add_client_modal">
                        <i class="fa fa-plus"></i> Create Client
                    </a>
                </div>
            </div>
        </div>

        <!-- Client Table -->
        <div class="table-responsive">
            <table id="clientTable" class="table table-striped">
                <thead>
                    <tr>
                        <th>Client ID</th>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Email</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($clients as $client)
                        <tr>
                            <td>{{ $client->client_id }}</td>
                            <td>{{ $client->first_name }}</td>
                            <td>{{ $client->last_name }}</td>
                            <td>{{ $client->email }}</td>
                            <td>
                                <button class="btn btn-primary edit-btn" data-id="{{ $client->id }}" data-toggle="modal" data-target="#add_client_modal">
                                    <i class="fa fa-edit"></i> 
                                </button>
                                <form action="{{ route('client.destroy', $client->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button class="btn btn-danger" type="submit" onclick="return confirm('Are you sure you want to delete this client?');">
                                        <i class="fa fa-trash"></i> 
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
    </div>
</div>

<!-- Add/Edit Client Modal -->
<div id="add_client_modal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Client</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('client.store') }}" method="POST" id="clientForm" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="client_id" id="client_id">
                    <div class="row">
                        <!-- First Name -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="first_name">First Name</label>
                                <input type="text" class="form-control" id="first_name" name="first_name" required>
                            </div>
                        </div>

                        <!-- Last Name -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="last_name">Last Name</label>
                                <input type="text" class="form-control" id="last_name" name="last_name" required>
                            </div>
                        </div>

                        <!-- Email -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                        </div>

                        <!-- Password -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="password">Password</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>
                        </div>

                        <!-- Confirm Password -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="confirm_password">Confirm Password</label>
                                <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                            </div>
                        </div>

                        <!-- Company Name -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="company_name">Company Name</label>
                                <input type="text" class="form-control" id="company_name" name="company_name" required>
                            </div>
                        </div>

                        <!-- Company Email -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="company_email">Company Email</label>
                                <input type="email" class="form-control" id="company_email" name="company_email" required>
                            </div>
                        </div>

                        <!-- Company Phone -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="company_phone">Company Phone</label>
                                <input type="text" class="form-control" id="company_phone" name="company_phone" required>
                            </div>
                        </div>

                        <!-- Company Mobile -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="company_mobile">Company Mobile</label>
                                <input type="text" class="form-control" id="company_mobile" name="company_mobile" required>
                            </div>
                        </div>

                        <!-- Company Country -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="company_country">Company Country</label>
                                <input type="text" class="form-control" id="company_country" name="company_country" required>
                            </div>
                        </div>

                        <!-- Company City -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="company_city">Company City</label>
                                <input type="text" class="form-control" id="company_city" name="company_city" required>
                            </div>
                        </div>

                        <!-- Company Zip Code -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="company_zip_code">Company Zip Code</label>
                                <input type="text" class="form-control" id="company_zip_code" name="company_zip_code" required>
                            </div>
                        </div>

                        <!-- Company Fax -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="company_fax">Company Fax</label>
                                <input type="text" class="form-control" id="company_fax" name="company_fax" required>
                            </div>
                        </div>

                        <!-- Company Website -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="company_website">Company Website</label>
                                <input type="url" class="form-control" id="company_website" name="company_website" required>
                            </div>
                        </div>

                        <!-- Skype -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="skype">Skype</label>
                                <input type="text" class="form-control" id="skype" name="skype" required>
                            </div>
                        </div>

                        <!-- Company Address -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="company_address">Company Address</label>
                                <input type="text" class="form-control" id="company_address" name="company_address" required>
                            </div>
                        </div>

                        <!-- Hosting Company -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="hosting_company">Hosting Company</label>
                                <input type="text" class="form-control" id="hosting_company" name="hosting_company" required>
                            </div>
                        </div>

                        <!-- Hosting Username -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="hosting_username">Hosting Username</label>
                                <input type="text" class="form-control" id="hosting_username" name="hosting_username" required>
                            </div>
                        </div>

                        <!-- Hosting Password -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="hosting_password">Hosting Password</label>
                                <input type="password" class="form-control" id="hosting_password" name="hosting_password" required>
                            </div>
                        </div>

                        <!-- Hosting Port -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="hosting_port">Hosting Port</label>
                                <input type="text" class="form-control" id="hosting_port" name="hosting_port" required>
                            </div>
                        </div>

                        <!-- Language -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="language">Language</label>
                                <input type="text" class="form-control" id="language" name="language" required>
                            </div>
                        </div>

                        <!-- Mobile -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="mobile">Mobile</label>
                                <input type="text" class="form-control" id="mobile" name="mobile" required>
                            </div>
                        </div>

                        <!-- Phone -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="phone">Phone</label>
                                <input type="text" class="form-control" id="phone" name="phone" required>
                            </div>
                        </div>

                        <!-- Skype Contact -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="skype_contact">Skype (Client Contact)</label>
                                <input type="text" class="form-control" id="skype_contact" name="skype_contact" required>
                            </div>
                        </div>

                        <!-- Country -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="country">Country</label>
                                <input type="text" class="form-control" id="country" name="country" required>
                            </div>
                        </div>

                        <!-- Address -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="address">Address</label>
                                <input type="text" class="form-control" id="address" name="address" required>
                            </div>
                        </div>

                        <!-- Profile Photo -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="profile_photo">Profile Photo</label>
                                <input type="file" class="form-control" id="profile_photo" name="profile_photo" required>
                            </div>
                        </div>

                        <!-- Social Media URLs -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="social_facebook_url">Facebook URL</label>
                                <input type="url" class="form-control" id="social_facebook_url" name="social_facebook_url" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="social_twitter_url">Twitter URL</label>
                                <input type="url" class="form-control" id="social_twitter_url" name="social_twitter_url" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="social_linkedin_url">LinkedIn URL</label>
                                <input type="url" class="form-control" id="social_linkedin_url" name="social_linkedin_url" required>
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">Save Client</button>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.11.4/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function() {
        let setUrl = null;
        $('#clientTable').DataTable({
            "paging": true,
            "searching": true,
            "ordering": true
        });
        
        $('.add-btn').on('click', function() {
            setUrl = "<?= route('client.store' ) ?>";
            $('#clientForm').attr('action',setUrl).attr('method','POST');
            $('#modal-title').text('Add Client');
            $('#confirm_password').attr('required',true);
            $('#password').attr('required',true);
            $('#clientForm')[0].reset();
            $('#profile_photo').attr('required',true);

        });
        
        // Populate modal for editing
        $('.edit-btn').on('click', function() {
            var clientId = $(this).data('id');
            $('#modal-title').text('Update Client');
            $('#password').removeAttr('required');
            $('#confirm_password').removeAttr('required');
            $('#profile_photo').removeAttr('required');
             setUrl = "<?= route('client.update', ['id' => ':id']) ?>".replace(':id', clientId);
            $.ajax({
                url: '/client/' + clientId + '/edit', // Ro~ute to get client data
                method: 'GET',
                success: function(data) {
                    
                   $('#clientForm').attr('action',setUrl).attr('method','POST');
                    $('#client_id').val(data.id);
                    $('#first_name').val(data.first_name);
                    $('#last_name').val(data.last_name);
                    $('#email').val(data.email);
                    $('#company_name').val(data.company_name);
                    $('#company_email').val(data.company_email);
                    $('#company_phone').val(data.company_phone);
                    $('#company_mobile').val(data.company_mobile);
                    $('#company_country').val(data.company_country);
                    $('#company_city').val(data.company_city);
                    $('#company_zip_code').val(data.company_zip_code);
                    $('#company_fax').val(data.company_fax);
                    $('#company_website').val(data.company_website);
                    $('#skype').val(data.skype);
                    $('#company_address').val(data.company_address);
                    $('#hosting_company').val(data.hosting_company);
                    $('#hosting_username').val(data.hosting_username);
                    $('#hosting_password').val(data.hosting_password);
                    $('#hosting_port').val(data.hosting_port);
                    $('#language').val(data.language);
                    $('#mobile').val(data.mobile);
                    $('#phone').val(data.phone);
                    $('#skype_contact').val(data.skype_contact);
                    $('#country').val(data.country);
                    $('#address').val(data.address);
                    $('#social_facebook_url').val(data.social_facebook_url);
                    $('#social_twitter_url').val(data.social_twitter_url);
                    $('#social_linkedin_url').val(data.social_linkedin_url);
                    // Add more fields as necessary...
                }
            });
        });
    });
</script>
@endsection
