@extends('layouts.master')
@section('content')

@section('style')
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.6.3/css/all.css">
    <link rel="stylesheet" href="{{ URL::to('assets/css/checkbox-style.css') }}">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.4/css/jquery.dataTables.min.css">
@endsection

<div class="page-wrapper">
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-lists-center">
                <div class="col">
                    <h3 class="page-title">Tasks</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html">Dashboard</a></li>
                        <li class="breadcrumb-item active">Tasks</li>
                    </ul>
                </div>
                @if (Auth::user()->role_name == 'Admin')

                <div class="col-auto float-right ml-auto">
                    <a href="#" class="btn add-btn" data-toggle="modal" data-target="#add_task_modal">
                        <i class="fa fa-plus"></i> Create Task
                    </a>
                </div>
                @endif
            </div>
        </div>

@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

        <!-- Task Table -->
        <div class="table-responsive">
            <table id="taskTable" class="table table-striped">
                <thead>
                    <tr>
                        <th>Task ID</th>
                        <th>Task Name</th>
                        <th>Project</th>
                        <th>Assigned To</th>
                        <th>Due Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Loop through the tasks and display them -->
                    @foreach ($tasks as $task)
                        <tr>
                            <td>{{ $task->id }}</td>
                            <td>{{ $task->task_name }}</td>
                            <td>{{ collect($projects)->firstWhere('id', $task->project_id )['project_name'] ?? '' }}</td>
                            <td>{{ collect($users)->firstWhere('id', $task->assigned_to )['name'] ?? '' }}</td>
                            <td>{{ date('Y-m-d', strtotime($task->end_date)) }}</td>
                            <td>{{ $task->task_status }}</td>
                            <td>
                                <button class="btn btn-primary edit-btn" data-id="{{ $task->id }}" data-toggle="modal" data-target="#add_task_modal">
                                    <i class="fa fa-edit"></i> 
                                </button>
                                <form action="{{ route('task.destroy', $task->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this task?');">
                                        <i class="fa fa-trash"></i> 
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
                
            </table>
        </div>
        
    </div>
</div>

<!-- Add/Edit Task Modal -->
<!-- Add/Edit Task Modal -->
<div id="add_task_modal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">Add Task</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
       
            <div class="modal-body">
                <form action="{{ route('task.store') }}" method="POST" id="taskForm">
                    @csrf
                    <!-- Hidden Field for Task ID -->
                    <input type="hidden" name="task_id" id="task_id">

                    <!-- Task Name -->
                    <div class="form-group">
                        <label for="task_name">Task Name</label>
                        <input type="text" class="form-control" id="task_name" name="task_name" value="" required>
                    </div>
                    <div class="form-group">
                        <label for="project_id">project id</label>
                        <select class="form-control" id="project_id" name="project_id" value="" required>
                        @foreach ($projects as $pro)
                                <option value="{{ $pro->id }}">{{ $pro->project_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <!-- Assigned To -->
                    <div class="form-group">
                        <label for="assigned_to">Assigned To</label>
                        <select class="form-control" id="assigned_to" name="assigned_to" value="" required>
                            @foreach ($users as $user)
                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Due Date -->
                    <div class="form-group">
                        <label for="due_date">Due Date</label>
                        <input type="date" class="form-control" id="due_date" name="due_date" value="" required>
                    </div>

                    <!-- Status -->
                    <div class="form-group">
                        <label for="task_status">Status</label>
                        <select class="form-control" id="task_status" name="task_status" value="" required>
                            <option value="pending">Pending</option>
                            <option value="in-progress">In Progress</option>
                            <option value="completed">Completed</option>
                        </select>
                    </div>

                    <!-- Priority Status -->
                    <div class="form-group">
                        <label for="priority_status">Priority Status</label>
                        <select class="form-control" id="priority_status" name="priority_status" value="" required>
                            <option value="low">Low</option>
                            <option value="medium">Medium</option>
                            <option value="high">High</option>
                        </select>
                    </div>

                    <!-- Plan Start Date -->
                    <div class="form-group">
                        <label for="plan_start_date">Plan Start Date</label>
                        <input type="date" class="form-control" id="plan_start_date" name="plan_start_date" value="" required>
                    </div>

                    <!-- Plan End Date -->
                    <div class="form-group">
                        <label for="plan_end_date">Plan End Date</label>
                        <input type="date" class="form-control" id="plan_end_date" name="plan_end_date" value="" required>
                    </div>

                    <!-- Start Date -->
                    <div class="form-group">
                        <label for="start_date">Start Date</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" value="" required>
                    </div>

                    <!-- End Date -->
                    <div class="form-group">
                        <label for="end_date">End Date</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" value="" required>
                    </div>

                    <!-- Total Hours -->
                    <div class="form-group">
                        <label for="total_hours">Total Hours</label>
                        <input type="number" class="form-control" id="total_hours" name="total_hours" step="0.01" value="" required>
                    </div>

                    <!-- Estimated Hours -->
                    <div class="form-group">
                        <label for="estimate_hours">Estimated Hours</label>
                        <input type="number" class="form-control" id="estimate_hours" name="estimate_hours" step="0.01" value="" required>
                    </div>

                    <!-- Progress -->
                    <div class="form-group">
                        <label for="progress">Progress (%)</label>
                        <input type="number" class="form-control" id="progress" name="progress" min="0" max="100" step="1" value="" required>
                    </div>

                    <!-- Description -->
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description" rows="3" required></textarea>
                    </div>
                    <div class="form-group">
                        <label for="creator_id">creator_id</label>
                        <input disabled type="text" class="form-control" id="creator_id" value="{{ Session::get('name') }}" required>
                        <input type="hidden" name="creator_id" value="{{ Session::get('user_id') }}">
                    </div>

                    <button type="submit" class="btn btn-primary">Save Task</button>
                </form>
            </div>
        </div>
    </div>
</div>


@endsection

@section('script')
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.11.4/js/jquery.dataTables.min.js"></script>
<script>
    $(document).ready(function() {
        let setUrl = null;
        $('#taskTable').DataTable({
            "paging": true,
            "searching": true,
            "ordering": true
        });

        $('.add-btn').on('click', function() {
            setUrl = "<?= route('task.store' ) ?>";
            $('#taskForm').attr('action',setUrl).attr('method','POST');
            $('.modal-title').text('Add Task');
            $('#taskForm')[0].reset();
            $('#description').text('');

        });
        
        // // Populate modal for editing
        $('.edit-btn').on('click', function() {
            var taskId = $(this).data('id');
            
            setUrl = "<?= route('task.update', ['id'=>':id']) ?>".replace(':id', taskId);
            
        //     // Load task data (use Ajax or load it from a hidden form if needed)

            $.ajax({
                url: '/tasks/edit', // Route to get task data (Change route as needed)
                method: 'POST',
                data: {id:taskId,
                        _token:'{{ csrf_token() }}'
                    },
                success: function(data) {
                    console.log(data);
                    console.log(data.task_name);
                    $('#task_id').val(data.id);
                    $('#task_name').val(data.task_name);
                    $('#assigned_to').val(data.assigned_to);
                    $('#due_date').val(data.due_date.split('T')[0]);
                    $('#plan_start_date').val(data.due_date.split('T')[0]);
                    $('#plan_end_date').val(data.due_date.split('T')[0]);
                    $('#start_date').val(data.due_date.split('T')[0]);
                    $('#end_date').val(data.due_date.split('T')[0]);
                    $('#total_hours').val(data.total_hours);
                    $('#estimate_hours').val(data.estimate_hours);
                    $('#progress').val(data.progress);
                    $('#description').text(data.description);
                    $('#creator_id').val(data.creator_id);
                    $('#project_id').val(data.project_id);

                    $('#status').val(data.status);
                    // Repeat for other fields...
                    $('#taskForm').attr('action',setUrl).attr('method','POST');
                        // Change modal title to 'Edit Project'
                    $('.modal-title').text('Edit Task');
                }
            });
        });
    });
</script>
@endsection
