// src/app/api/login/route.ts
import { NextRequest, NextResponse } from 'next/server';
import axios, { AxiosError } from 'axios';
import { API_BASE_PATH } from "@/config/apiConfig";
const API_BASE_URL = API_BASE_PATH;

export async function POST(req: NextRequest) {
  try {
    const body = await req.json();
    const { username, password, remember_me } = body;

    const formData = new URLSearchParams();
    formData.append('username', username);
    formData.append('password', password);
    formData.append('scope', '');
    formData.append('client_id', 'string');
    formData.append('client_secret', 'string');
    formData.append('remember_me', remember_me || 'false');
    const response = await axios.post(`${API_BASE_URL}/login`, formData, {
      headers: {
        Accept: 'application/json',
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });

    return NextResponse.json({
      user_id: response.data.user_id,
  name: response.data.name,
  role: response.data.role,
  access_token: response.data.access_token,
  token_type: response.data.token_type,
  expires_in: response.data.expires_in, 
    }, { status: 200 });

  } catch (error) {
    const axiosError = error as AxiosError<{ message: string }>;

    return NextResponse.json({
      message: axiosError.response?.data?.message || 'Login failed',
    }, { status: axiosError.response?.status || 500 });
  }
}
