'use client';

import { useEffect, useState } from 'react';
import { usePathname } from 'next/navigation';
import clsx from 'clsx';

const TopRouteLoader = () => {
  const [visible, setVisible] = useState(false);
  const [width, setWidth] = useState(0);
  const pathname = usePathname();

  useEffect(() => {
    // Start loading
    setVisible(true);
    setWidth(20);

    const progressInterval = setInterval(() => {
      setWidth((prev) => {
        if (prev >= 95) return prev;
        return prev + Math.random() * 10;
      });
    }, 150);

    // Complete loading after route changes
    const completeTimeout = setTimeout(() => {
      setWidth(100);
      setTimeout(() => {
        setVisible(false);
        setWidth(0);
      }, 300);
    }, 1200); // total animation duration ~1.5s

    return () => {
      clearInterval(progressInterval);
      clearTimeout(completeTimeout);
    };
  }, [pathname]);

  return visible ? (
    <div className="fixed top-0 left-0 z-[9999] w-full h-1">
      <div
        className={clsx(
          'h-full bg-green-500 rounded-r-full shadow-[0_0_10px_2px_rgba(34,197,94,0.6)] transition-all duration-200 ease-in-out'
        )}
        style={{ width: `${width}%` }}
      />
    </div>
  ) : null;
};

export default TopRouteLoader;
