import type { Corners } from '../../../shared';
interface Point {
    x: number;
    y: number;
}
interface Corner {
    corner: Corners;
    translation: Point;
}
export declare function Draggable({ children, padding, position: currentCorner, setPosition: setCurrentCorner, onDragStart, dragHandleSelector, disableDrag, avoidZone, ...props }: {
    children: React.ReactElement;
    position: Corners;
    padding: number;
    setPosition: (position: Corners) => void;
    onDragStart?: () => void;
    dragHandleSelector?: string;
    disableDrag?: boolean;
    style?: React.CSSProperties;
    avoidZone?: {
        square: number;
        corner: Corners;
        padding: number;
    };
}): import("react/jsx-runtime").JSX.Element;
interface UseDragOptions {
    disabled: boolean;
    onDragStart?: () => void;
    onDrag?: (translation: Point) => void;
    onDragEnd?: (translation: Point, velocity: Point) => void;
    onAnimationEnd?: (corner: Corner) => void;
    threshold: number;
    dragHandleSelector?: string;
    handles?: Set<HTMLElement>;
}
export declare function useDrag(options: UseDragOptions): {
    ref: import("react").RefObject<HTMLDivElement | null>;
    animate: (corner: Corner) => void;
    onPointerDown?: undefined;
} | {
    ref: import("react").RefObject<HTMLDivElement | null>;
    onPointerDown: (e: React.PointerEvent) => void;
    animate: (corner: Corner) => void;
};
export {};
