import { type OverlayDispatch } from '../../../shared';
import type { SupportedErrorEvent } from '../../../container/runtime-error/render-error';
/**
 * When the Turbopack persistent cache is enabled, and the user reloads on a
 * specific error and that error persists, we show the restart server button as
 * an option. This is because some errors are recoverable by clearing the
 * bundler cache, but we want to provide a shortcut to do this and collect
 * telemetry on how often this is used.
 */
export declare function RestartServerButton({ showButton }: {
    showButton: boolean;
}): import("react/jsx-runtime").JSX.Element | null;
/**
 * Sets up a beforeunload listener to show the restart server button
 * if the developer reloads on a specific error and that error persists with Turbopack + Persistent Cache.
 */
export declare function usePersistentCacheErrorDetection({ errors, dispatch, }: {
    errors: SupportedErrorEvent[];
    dispatch: OverlayDispatch;
}): void;
export declare const RESTART_SERVER_BUTTON_STYLES: string;
