import { type Dispatch, type SetStateAction } from 'react';
interface C {
    closeMenu?: () => void;
    selectedIndex: number;
    setSelectedIndex: Dispatch<SetStateAction<number>>;
}
export declare const MenuContext: import("react").Context<C>;
export declare function MenuItem({ index, label, value, onClick, href, ...props }: {
    index?: number;
    title?: string;
    label: string;
    value: React.ReactNode;
    href?: string;
    onClick?: () => void;
}): import("react/jsx-runtime").JSX.Element;
export declare const DevtoolMenu: ({ closeOnClickOutside, items, }: {
    closeOnClickOutside?: boolean;
    items: Array<false | undefined | null | {
        onClick?: () => void;
        title?: string;
        label: string;
        value: React.ReactNode;
        attributes?: Record<string, string | boolean>;
        footer?: boolean;
    }>;
}) => import("react/jsx-runtime").JSX.Element;
export declare function getAdjustedIndex(items: Array<{
    onClick?: () => void;
}>, targetIndex: number): number;
export declare function getClickableItemsCount(items: Array<{
    onClick?: () => void;
}>): number;
export declare function IssueCount({ children }: {
    children: number;
}): import("react/jsx-runtime").JSX.Element;
export declare function ChevronRight(): import("react/jsx-runtime").JSX.Element;
export declare function selectMenuItem({ index, menuRef, setSelectedIndex, }: {
    index: number | 'first' | 'last';
    menuRef: React.RefObject<HTMLDivElement | null>;
    setSelectedIndex: (index: number) => void;
}): void;
export {};
