"use client";

import React from "react";
import { Table, TableProps } from "antd";
import type { ColumnsType } from "antd/es/table";

export interface DataTableProps<T> {
  columns: ColumnsType<T>;
  dataSource: T[];
  loading?: boolean;
   scrollX?: number | string | { x: string | number }; // ✅ Allow string like 'max-content'
  pagination?: TableProps<T>["pagination"];
  rowKey?: string | ((record: T) => string);
  bordered?: boolean;
  onRowClick?: (record: T) => void;
  sticky?: boolean;
  className?: string;
}

function DataTable<T extends object>({
  columns,
  dataSource,
  loading = false,
  scrollX = "max-content" , // ✅ default is now 'max-content'
  pagination = { pageSize: 10, showSizeChanger: true },
  rowKey = "id",
  bordered = true,
  onRowClick,
  sticky = false,
  className,
}: DataTableProps<T>) {
  return (
    <Table<T>
      columns={columns}
      dataSource={dataSource}
      loading={loading}
       scroll={typeof scrollX === 'object' ? scrollX : { x: scrollX }}// ✅ use dynamic scroll value
      pagination={pagination}
      rowKey={rowKey}
      bordered={bordered}
      sticky={sticky}
      onRow={
        onRowClick ? (record) => ({ onClick: () => onRowClick(record) }) : undefined
      }
      className={className}
    />
  );
}

export default DataTable;
